package com.clx.performance.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.IntegralStatisticsDao;
import com.clx.performance.dao.IntegralTruckDao;
import com.clx.performance.extranal.user.DriverService;
import com.clx.performance.model.IntegralRecord;
import com.clx.performance.model.IntegralStatistics;
import com.clx.performance.model.IntegralTruck;
import com.clx.performance.param.pc.IntegralTruckAddParam;
import com.clx.performance.param.pc.PageIntegralTruckParam;
import com.clx.performance.param.pc.PageIntegralTruckRankParam;
import com.clx.performance.service.*;
import com.clx.performance.utils.LocalDateTimeUtils;
import com.clx.performance.vo.pc.IntegralTruckVO;
import com.clx.user.vo.feign.DriverInfoFeignVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@Service
public class IntegralTruckServiceImpl implements IntegralTruckService {

    @Autowired
    private IntegralTruckDao integralTruckDao;
    @Autowired
    private IntegralStatisticsDao integralStatisticsDao;

    @Autowired
    private IntegralRecordService integralRecordService;
    @Autowired
    private IntegralStatisticsService integralStatisticsService;

    @Autowired
    private DriverService driverService;

    @Autowired
    private IntegralMqService integralMqService;

    @Autowired
    private IntegralMqHandlerService integralMqHandlerService;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveTruck(IntegralTruckAddParam param) {
        String truckNo = param.getTruckNo();

        boolean existFlag = integralTruckDao.existByTruckNo(truckNo);
        if (existFlag) {return;}

        IntegralTruck truck = new IntegralTruck();
        truck.setTruckNo(truckNo);
        truck.setDriverName(param.getDriverName());
        truck.setDriverMobile(param.getDriverMobile());
        truck.setEchelon(1);

        LocalDateTime statisticsDate = LocalDateTimeUtils.getStartWeek();
        int protectionIntegral = integralStatisticsService.protectionIntegralCalc(statisticsDate);
        int baseIntegral = 100;

        // 初始化统计
        IntegralStatistics statistics = new IntegralStatistics();
        statistics.setTruckNo(truckNo);
        statistics.setStatisticsDate(statisticsDate);
        statistics.setIntegralBase(0);
        statistics.setIntegral(protectionIntegral+baseIntegral);   //保护分+基础分
        statistics.setRank(1);
        integralStatisticsDao.saveEntity(statistics);

        IntegralStatistics statisticsNext = new IntegralStatistics();
        statisticsNext.setTruckNo(truckNo);
        statisticsNext.setStatisticsDate(statistics.getStatisticsDate().plusDays(7));
        statisticsNext.setIntegralBase(0);
        statisticsNext.setIntegral(0);
        statisticsNext.setRank(1);
        integralStatisticsDao.saveEntity(statisticsNext);

        // 新增车辆
        truck.setIntegral(statistics.getIntegral());
        integralTruckDao.saveEntity(truck);

        // 新增积分记录
        integralRecordService.save(statistics.getId(), statistics.getStatisticsDate(), statistics.getTruckNo(), IntegralRecord.type.PROTECTION.getValue(), protectionIntegral, "新用户");
        integralRecordService.save(statistics.getId(), statistics.getStatisticsDate(), statistics.getTruckNo(), IntegralRecord.type.BASE.getValue(), baseIntegral, "基础分");

        // 实时积分统计
        integralMqHandlerService.integralRealTimeStatistics(statistics.getId());

    }

    @Override
    public IPage<IntegralTruckVO> pageTruckList(PageIntegralTruckParam param) {
        return integralTruckDao.pageByParam(param);
    }

    @Override
    public IntegralTruckVO getTruckDriverInfo(String truckNo) {
        IntegralTruckVO truck = null;

        // 查询车辆信息
        DriverInfoFeignVo driverTruckInfoFeignVo = driverService.getTruckOwnInfo(truckNo).get();

        if (null != driverTruckInfoFeignVo) {
            truck = new IntegralTruckVO();
            truck.setTruckNo(truckNo);
            truck.setDriverName(driverTruckInfoFeignVo.getName());
            truck.setDriverMobile(driverTruckInfoFeignVo.getMobile());
        }

        return truck;
    }

    @Override
    public Integer getTruckCount(Integer truckEchelon) {
        int count = (int)integralTruckDao.countByTruckEchelon(truckEchelon);

        return count;
    }

    @Override
    public IPage<IntegralTruckVO> pageTruckRank(PageIntegralTruckRankParam param) {

        IPage<IntegralTruckVO> page = integralTruckDao.pageTruckRank(param);

        List<String> truckNoList = page.getRecords().stream().map(item -> item.getTruckNo()).collect(Collectors.toList());
        if (!truckNoList.isEmpty()) {
            List<IntegralStatistics> statisticsList = integralStatisticsDao.selectListByStatisticsDateAndTruckNoList(LocalDateTimeUtils.getWeekStart(), truckNoList);
            Map<String, Integer> rankMap = statisticsList.stream().collect(Collectors.toMap(item -> item.getTruckNo(), item -> item.getRank()));

            for (IntegralTruckVO item : page.getRecords()) {
                item.setRank(rankMap.get(item.getTruckNo()));
            }
        }

        return page;

    }

}
