package com.clx.performance.dao.impl.breakcontract;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.breakcontract.BreakContractSettlementDriverDetailDao;
import com.clx.performance.mapper.breakcontract.BreakContractSettlementDriverDetailMapper;
import com.clx.performance.model.breakcontract.BreakContractSettlementDriverDetail;
import com.clx.performance.model.breakcontract.BreakContractSettlementOwnerDetail;
import com.clx.performance.param.pc.breakcontract.carrier.PageCarrierBreakContractSettlementDriverDetailParam;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Objects;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Repository
public class BreakContractSettlementDriverDetailDaoImpl extends BaseDaoImpl<BreakContractSettlementDriverDetailMapper, BreakContractSettlementDriverDetail, Integer> implements BreakContractSettlementDriverDetailDao {

    @Override
    public IPage<BreakContractSettlementDriverDetail> pageCarrierBreakContractSettlementDriverDetailList(PageCarrierBreakContractSettlementDriverDetailParam param) {
        LambdaQueryWrapper<BreakContractSettlementDriverDetail> query = new LambdaQueryWrapper<>();
        query.eq(StringUtils.isNotBlank(param.getChildNo()),BreakContractSettlementDriverDetail :: getChildNo,param.getChildNo());
        query.eq(Objects.nonNull(param.getTruckOwnUserNo()),BreakContractSettlementDriverDetail :: getTruckOwnUserNo,param.getTruckOwnUserNo());
        query.eq(StringUtils.isNotBlank(param.getTruckOwnName()),BreakContractSettlementDriverDetail :: getTruckOwnName,param.getTruckOwnName());
        query.eq(Objects.nonNull(param.getBreakContractPartyType()),BreakContractSettlementDriverDetail :: getBreakContractPartyType,param.getBreakContractPartyType());
        query.orderByDesc(BreakContractSettlementDriverDetail::getId);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }
}
