package com.clx.performance.controller.payment;

import com.clx.performance.param.pay.NotifyParam;
import com.clx.performance.param.pc.GoodsOrderMapParam;
import com.clx.performance.vo.pc.GoodsOrderSendAddressSelect;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Objects;


@Slf4j
@RestController
@RequestMapping(value="/payment/notify")
@Validated
@Api(tags = "承运端-支付回调")
@AllArgsConstructor
public class PayNotifyController {

    @ApiOperation(value = "用户支付完成回调接口", notes = " <br>By:许建科")
    @RequestMapping(value = "/userPayNotify", method = RequestMethod.POST)
    public Result<Object> userPayNotify(@RequestBody NotifyParam notify) {
        log.info("用户支付完成回调接口 传参 {}", notify);
        if (Objects.isNull(notify) || Objects.isNull(notify.getCode()) || Objects.isNull(notify.getAction())) {
            return new Result<>();
        }
        if (notify.getCode() != 0) {
            // 支付失败处理
            log.info("唯一id {}", notify.getOrderNo());
        } else {
            // 支付支付成功处理
            log.info("唯一id {}", notify.getOrderNo());
        }
        Result<Object> ret = new Result<>();
        return ret;
    }

}
