package com.clx.performance.param.pay;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.apache.poi.ss.formula.functions.T;

@ApiModel(description = "货主绑卡")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class NotifyParam {
    /** 支付操作 参考<MessageTypeEnum> */
    private Integer action;
    /** 交易单号 */
    private String orderNo;
    /** 支付请求唯一ID */
    private String uuid;
    /** 出错时的交易单元编号 */
    private String errorNo;

    private Integer code; // 返回结果代码，0为成功
    private Long total;//总共记录数

    private Integer pageNum;//总共页数

    private String msg;
    private T data;

}
