package com.clx.performance.service.impl;

import com.clx.performance.enums.PerformanceProgressEnum;
import com.clx.performance.model.PerformanceProgressLog;
import com.clx.performance.service.PerformanceProgressLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author kavin
 * Date 2024-07-12
 * Time 16:02
 */
@Service
@Slf4j
public class PerformanceProgressLogServiceImpl  implements PerformanceProgressLogService {
    @Override
    public PerformanceProgressLog generateLog(String orderNo, PerformanceProgressEnum.LogType logType,
            Object content, Long userNo, String userName) {
        PerformanceProgressLog log = new PerformanceProgressLog();
        log.setOrderNo(orderNo);
        log.setOperateType(logType.getCode());
        log.setOperateContent(logType.getName() + ":" + (Objects.isNull(content)?"-":content));
        log.setCreateBy(userNo);
        log.setCreateName(userName);
        return log;
    }
}
