package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * @author jiangwujie
 * Date 2024-08-08
 * Time 11:20
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("order_child_operate_record")
public class OrderChildOperateRecord implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("child_no")
    @ApiModelProperty("运单编号")
    private String childNo;

    @TableField("type")
    @ApiModelProperty("操作类型 1 取消运单 2 解除装车限制")
    private Integer type;

    @TableField("truck_no")
    @ApiModelProperty("主车牌照")
    private String truckNo;

    @TableField("driver_name")
    @ApiModelProperty("司机名称")
    private String driverName;

    @TableField("driver_mobile")
    @ApiModelProperty("司机手机号")
    private String driverMobile;

    @TableField("send_address")
    @ApiModelProperty("货源地")
    private String sendAddress;

    @TableField("receive_address")
    @ApiModelProperty("目的地")
    private String receiveAddress;

    @TableField("good_type_name")
    @ApiModelProperty("货物类型名称")
    private String goodTypeName;

    @TableField("remark")
    @ApiModelProperty("备注")
    private String remark;

    @TableField("operate_time")
    @ApiModelProperty("操作时间")
    private LocalDateTime operateTime;

    @TableField("operator")
    @ApiModelProperty("操作人")
    private String operator;

    @TableField("created_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createdTime;

    @TableField("modified_time")
    @ApiModelProperty("更新时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
        return this.id;
    }
}
