/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.oscca;

import cn.com.infosec.asn1.x9.X9IntegerConverter;
import cn.com.infosec.jce.oscca.JPECMultiplier;
import cn.com.infosec.jce.oscca.JPPreCompInfo;
import cn.com.infosec.jce.oscca.JPWNafMultiplier;
import cn.com.infosec.jce.oscca.SM2;
import cn.com.infosec.jce.oscca.SM2Constants;
import cn.com.infosec.math.ec.ECCurve;
import cn.com.infosec.math.ec.ECFieldElement;
import cn.com.infosec.math.ec.ECPoint;
import java.math.BigInteger;

public abstract class JPECPoint {
    ECCurve curve;
    ECFieldElement x;
    ECFieldElement y;
    ECFieldElement z;
    protected boolean withCompression;
    protected JPECPoint infinity = null;
    protected JPECMultiplier multiplier = null;
    protected JPPreCompInfo preCompInfo = null;
    private static X9IntegerConverter converter = new X9IntegerConverter();

    protected JPECPoint(ECCurve curve, ECFieldElement x, ECFieldElement y, ECFieldElement z) {
        this.curve = curve;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public JPECPoint(ECPoint point) {
        if (point.isInfinity()) {
            this.curve = null;
            this.x = null;
            this.y = null;
            this.z = null;
        } else {
            this.curve = point.getCurve();
            this.x = point.getX();
            this.y = point.getY();
            this.z = new ECFieldElement.Fp(SM2.gmp, BigInteger.ONE);
        }
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public ECFieldElement getX() {
        return this.x;
    }

    public ECFieldElement getY() {
        return this.y;
    }

    public ECFieldElement getZ() {
        return this.z;
    }

    public boolean isInfinity() {
        return this.x == null && this.y == null && this.z == null;
    }

    public JPECPoint getInfinity() {
        return new Fp(SM2.gmec256.getInfinity());
    }

    public boolean isCompressed() {
        return this.withCompression;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof JPECPoint)) {
            return false;
        }
        JPECPoint o = (JPECPoint)other;
        if (this.isInfinity()) {
            return o.isInfinity();
        }
        return this.x.equals(o.x) && this.y.equals(o.y);
    }

    public int hashCode() {
        if (this.isInfinity()) {
            return 0;
        }
        return this.x.hashCode() ^ this.y.hashCode();
    }

    void setPreCompInfo(JPPreCompInfo preCompInfo) {
        this.preCompInfo = preCompInfo;
    }

    public abstract byte[] getEncoded();

    public abstract JPECPoint add(JPECPoint var1);

    public abstract JPECPoint subtract(JPECPoint var1);

    public abstract JPECPoint negate();

    public abstract JPECPoint twice();

    synchronized void assertECMultiplier() {
        if (this.multiplier == null) {
            this.multiplier = new JPWNafMultiplier();
        }
    }

    ECPoint toECPoint() {
        BigInteger ax = null;
        BigInteger ay = null;
        BigInteger zi = this.z.toBigInteger().modInverse(SM2.gmp);
        BigInteger zi2 = zi.multiply(zi);
        ax = this.x.toBigInteger().multiply(zi2).mod(SM2.gmp);
        ay = this.y.toBigInteger().multiply(zi).multiply(zi2).mod(SM2.gmp);
        return SM2.gmec256.createPoint(ax, ay, false);
    }

    public JPECPoint multiply(BigInteger k) {
        if (k.signum() < 0) {
            throw new IllegalArgumentException("The multiplicator cannot be negative");
        }
        if (this.isInfinity()) {
            return this;
        }
        if (k.signum() == 0) {
            return this.infinity;
        }
        this.assertECMultiplier();
        return this.multiplier.multiply(this, k, this.preCompInfo);
    }

    public static class Fp
    extends JPECPoint {
        public Fp(ECCurve curve, ECFieldElement x, ECFieldElement y, ECFieldElement z) {
            this(curve, x, y, z, false);
        }

        public Fp(ECCurve curve, ECFieldElement x, ECFieldElement y) {
            this(curve, x, y, SM2Constants.ONE, false);
        }

        public Fp(ECPoint point) {
            super(point);
        }

        public Fp(ECCurve curve, ECFieldElement x, ECFieldElement y, ECFieldElement z, boolean withCompression) {
            super(curve, x, y, z);
            if (x != null && y == null || x == null && y != null) {
                throw new IllegalArgumentException("Exactly one of the field elements is null");
            }
            this.withCompression = withCompression;
        }

        public byte[] getEncoded() {
            if (this.isInfinity()) {
                return new byte[1];
            }
            ECPoint ecp = this.toECPoint();
            int qLength = converter.getByteLength(ecp.getX());
            if (this.withCompression) {
                int PC = ecp.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] X = converter.integerToBytes(ecp.getX().toBigInteger(), qLength);
                byte[] PO = new byte[X.length + 1];
                PO[0] = PC;
                System.arraycopy(X, 0, PO, 1, X.length);
                return PO;
            }
            byte[] X = converter.integerToBytes(ecp.getX().toBigInteger(), qLength);
            byte[] Y = converter.integerToBytes(ecp.getY().toBigInteger(), qLength);
            byte[] PO = new byte[X.length + Y.length + 1];
            PO[0] = 4;
            System.arraycopy(X, 0, PO, 1, X.length);
            System.arraycopy(Y, 0, PO, X.length + 1, Y.length);
            return PO;
        }

        public JPECPoint add(JPECPoint b) {
            if (this.isInfinity()) {
                return b;
            }
            if (b.isInfinity()) {
                return this;
            }
            if (this.x.equals(b.x)) {
                if (this.y.equals(b.y)) {
                    return this.twice();
                }
                return this.infinity;
            }
            ECFieldElement z1s = this.z.square();
            ECFieldElement z2s = b.getZ().square();
            ECFieldElement lbd1 = this.x.multiply(z2s);
            ECFieldElement lbd2 = b.getX().multiply(z1s);
            ECFieldElement lbd3 = lbd1.subtract(lbd2);
            ECFieldElement lbd4 = this.y.multiply(z2s).multiply(b.getZ());
            ECFieldElement lbd5 = b.getY().multiply(z1s).multiply(this.z);
            ECFieldElement lbd6 = lbd4.subtract(lbd5);
            ECFieldElement lbd7 = lbd1.add(lbd2);
            ECFieldElement lbd8 = lbd4.add(lbd5);
            ECFieldElement x3 = lbd6.square().subtract(lbd7.multiply(lbd3.square()));
            ECFieldElement lbd9 = lbd7.multiply(lbd3.square()).subtract(x3).subtract(x3);
            ECFieldElement y3 = lbd9.multiply(lbd6).subtract(lbd8.multiply(lbd3.square()).multiply(lbd3)).divide(SM2Constants.TWO);
            ECFieldElement z3 = this.z.multiply(b.getZ()).multiply(lbd3);
            return new Fp(this.curve, x3, y3, z3);
        }

        public JPECPoint twice() {
            if (this.isInfinity()) {
                return this;
            }
            ECFieldElement lbd1 = SM2Constants.THREE.multiply(this.x.square()).add(this.z.square().square().multiply(SM2Constants.A));
            ECFieldElement lbd2 = SM2Constants.FOUR.multiply(this.x).multiply(this.y.square());
            ECFieldElement lbd3 = SM2Constants.EIGHT.multiply(this.y.square().square());
            ECFieldElement x3 = lbd1.square().subtract(SM2Constants.TWO.multiply(lbd2));
            ECFieldElement y3 = lbd2.subtract(x3).multiply(lbd1).subtract(lbd3);
            ECFieldElement z3 = SM2Constants.TWO.multiply(this.y).multiply(this.z);
            return new Fp(this.curve, x3, y3, z3);
        }

        public JPECPoint subtract(JPECPoint b) {
            if (b.isInfinity()) {
                return this;
            }
            return this.add(b.negate());
        }

        public JPECPoint negate() {
            return new Fp(this.curve, this.x, this.y.negate(), this.z);
        }

        synchronized void assertECMultiplier() {
            if (this.multiplier == null) {
                this.multiplier = new JPWNafMultiplier();
            }
        }
    }
}

