package com.clx.performance.dto.zjxl;

import com.clx.performance.utils.zjxl.ZJXLPositionUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @ClassName TruckTraceDTO
 * @Description
 * @Author kavin
 * @Date 2023/9/18 13:03
 * @Version 1.0
 */
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class TruckTraceDTO {
    @Schema(description = "车牌号")
    private String truckNo;
    @Schema(description = "正北方向夹角", example = "90")
    private BigDecimal angle;
    @Schema(description = "GPS 速度", example = "602")
    private BigDecimal speed;
    @Schema(description = "里程", example = "1500")
    private BigDecimal mileage;
    @Schema(description = "海拔", example = "3250")
    private BigDecimal height;
    @Schema(description = "经纬度", example = "[66536286,23780995]")
    private BigDecimal[] location;
    @Schema(description = "GPS 时间", example = "20140325/104954")
    private String gpsTime;
    private String createTime;
    private String modifiedTime;


    public TruckTraceDTO(String angle, String speed, String mileage, String height, String lon, String lat, String gpsTime) {
        this.angle = new BigDecimal(angle);
        this.speed = ZJXLPositionUtils.speedFormat(speed);
        this.mileage = ZJXLPositionUtils.mileageFormat(mileage);
        this.height = new BigDecimal(height);
        this.location = ZJXLPositionUtils.WGS484Format(lon, lat);
        this.gpsTime = ZJXLPositionUtils.gpsTimeFormat(gpsTime);
    }
}
