package com.clx.performance.dao.settle;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.mapper.settle.SettlementDriverMapper;
import com.clx.performance.model.settle.SettlementDriver;
import com.clx.performance.param.pc.driver.PageCarrierSettlementDriverParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.BaseDao;

import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 车主结算单
 * @Date: 2023-10-11 18:00:53
 * @Version: 1.0
 */
public interface SettlementDriverDao extends BaseDao<SettlementDriverMapper, SettlementDriver, Integer> {

    boolean updatePayStatus(SettlementDriver item);


    boolean updateInvoiceCompany(SettlementDriver item);

    boolean updateSettleStatus(SettlementDriver item);

    Optional<SettlementDriver> findBySettlementNo(String settlementNo);

    Optional<SettlementDriver> findByChildNo(String childNo);

    List<SettlementDriver> listDriverConfirmSync();

    IPage<SettlementDriver> pageCarrierSettlementDriver(PageCarrierSettlementDriverParam param);


    Optional<SettlementDriver> getByChildNo(String childNo);

    void updateLoanFlagByChildNoList(List<String> childNoList);

    void updateStatus(Integer id,Integer status);

    void updatePayErrorMsg(Integer id,String payErrorMsg);
}
