package com.clx.performance.controller.pc.linewarn;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.linewarn.*;
import com.clx.performance.service.linewarn.LineWarnInfoService;
import com.clx.performance.vo.pc.linewarn.LineWarnInfoVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.constraints.NotNull;


@Slf4j
@RestController
@Validated
@Tag(name = "线路预警-预警信息")
@RequestMapping(value="/pc/lineWarnInfo")
public class LineWarnInfoController {

    @Autowired
    private LineWarnInfoService lineWarnInfoService;

    @Operation(summary = "更新预警暂停", description = "<br>By:艾庆国")
    @PostMapping("/updateSuspend")
    public Result<Void> updateSuspend(@RequestBody @Validated LineWarnInfoSuspendUpdateParam param) {
        lineWarnInfoService.updateSuspend(param);
        return Result.ok();
    }

    @Operation(summary = "更新处理", description = "<br>By:艾庆国")
    @PostMapping("/updateResolve")
    public Result<Void> updateConfig(@RequestBody @Validated LineWarnInfoResolveUpdateParam param) {
        lineWarnInfoService.updateResolve(param);
        return Result.ok();
    }

    @Operation(summary = "获取预警信息",description = "<br>By:艾庆国")
    @GetMapping("/getInfo")
    public Result<LineWarnInfoVO> getInfo(@NotNull(message = "id不能为空") @Validated Integer id) {
        return Result.ok(lineWarnInfoService.getInfo(id));
    }

    @Operation(summary = "分页搜索预警信息列表",description = "<br>By:艾庆国")
    @PostMapping("/pageInfo")
    public Result<PageData<LineWarnInfoVO>> pageInfo(@RequestBody @Validated PageLineWarnInfoParam param) {
        IPage<LineWarnInfoVO> page = lineWarnInfoService.pageInfo(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
