package com.clx.performance.controller.app.breakcontract;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.breakcontract.DriverPageBreakContractDriverRecordParam;
import com.clx.performance.service.breakcontract.BreakContractDriverRecordService;
import com.clx.performance.utils.LocalDateTimeUtils;
import com.clx.performance.vo.app.breakcontract.DriverBreakContractDriverRecordVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;


@Slf4j
@RestController
@RequestMapping(value="/pc/driver/breakContract/record")
@Validated
@Tag(name = "司机APP-违约")
@AllArgsConstructor
public class AppDriverBreakContractDriverRecordController {

    private final BreakContractDriverRecordService breakContractDriverRecordService;

    @Operation(summary = "分页搜索违约列表",description = "<br>By:艾庆国")
    @PostMapping("/pageRecord")
    @UnitCovert(param = false)
    public Result<PageData<DriverBreakContractDriverRecordVO>> pageRecord(@RequestBody @Validated DriverPageBreakContractDriverRecordParam param) {

        if (StringUtils.isBlank(param.getCreateTime())) {param.setCreateTime(LocalDateTimeUtils.formatTime());}
        param.setBeginTime(LocalDateTimeUtils.getStringMonthStart(param.getCreateTime()));
        param.setEndTime(LocalDateTimeUtils.getStringMonthEnd(param.getCreateTime()));

        IPage<DriverBreakContractDriverRecordVO> page = breakContractDriverRecordService.driverPageRecord(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "查询运单取消违约金额", description = "<br>By:艾庆国")
    @GetMapping("/getOrderChildCancelBreakContractFigure")
    public Result<BigDecimal> getBreakContractFigure(String childNo) {
        return Result.ok(breakContractDriverRecordService.getBreakContractFigure(childNo));
    }

}
