package com.clx.performance.config;

import org.hibernate.validator.HibernateValidator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import jakarta.validation.Validation;
import jakarta.validation.Validator;

/**
 * 快速校验，参数错误不校验剩余参数直接抛出异常
 *
 * @author wanglq
 * Date 2022/5/23
 * Time 14:35
 */
@Configuration
public class ValidConfig {
    @Bean
    public Validator validator() {
        return Validation.byProvider(HibernateValidator.class)
                .configure()
                //快速失败模式
                .failFast(true)
                .buildValidatorFactory()
                .getValidator();
    }
}
