package com.clx.performance.config;

import com.msl.common.trace.context.TracedThreadPoolExecutor;
import org.apache.skywalking.apm.toolkit.trace.RunnableWrapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author wanglq
 * Date 2022/6/30
 * Time 11:14 上午
 */
@Configuration
public class ThreadPool {

    public static final ThreadPoolExecutor COMMON;

    public static final Scheduler SCHEDULER;


    static {
        COMMON = new TracedThreadPoolExecutor(10, 30, 120,
                TimeUnit.SECONDS, new ArrayBlockingQueue<>(500),
                new CustomizableThreadFactory("common-pool-"),
                new ThreadPoolExecutor.CallerRunsPolicy()) {
            @Override
            public void execute(Runnable command) {
                super.execute(RunnableWrapper.of(command));
            }
        };

        SCHEDULER = Schedulers.fromExecutor(COMMON);

    }

    @Bean("common")
    public ThreadPoolExecutor getThreadPool() {
        return COMMON;
    }

}
