package com.clx.performance.config;

import com.clx.performance.constant.RabbitKeyLineWarnConstants;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: aiqingguo
 * @Description: 货款往来明细 MQ
 * @Date: 2023-10-12 16:27:30
 * @Version: 1.0
 */
@Configuration
public class RabbitLineWarnConfig {

    @Bean
    public DirectExchange lineWarnDefaultExchange() {
        return new DirectExchange(RabbitKeyLineWarnConstants.DEFAULT_EXCHANGE);
    }

    @Bean
    public Queue lineWarnDefaultDelayQueue() {
        Map<String, Object> params = new HashMap<>(8);
        params.put("x-message-ttl", 15 * 60 * 1000);
        params.put("x-max-length", 5000000);
        params.put("x-dead-letter-exchange", RabbitKeyLineWarnConstants.DEFAULT_EXCHANGE);
        params.put("x-dead-letter-routing-key", RabbitKeyLineWarnConstants.DEFAULT_DEAD_ROUTING_KEY);
        return new Queue(RabbitKeyLineWarnConstants.DEFAULT_DELAY_QUEUE,
                true, false, false, params);
    }
    @Bean
    public Binding lineWarnDefaultDelayQueueBinding() {
        return BindingBuilder.bind(lineWarnDefaultDelayQueue()).to(lineWarnDefaultExchange())
                .with(RabbitKeyLineWarnConstants.DEFAULT_DELAY_ROUTING_KEY);
    }

    @Bean
    public Queue lineWarnDefaultDeadQueue() {
        return new Queue(RabbitKeyLineWarnConstants.DEFAULT_DEAD_QUEUE);
    }
    @Bean
    public Binding lineWarnDefaultDeadQueueBinding() {
        return BindingBuilder.bind(lineWarnDefaultDeadQueue()).to(lineWarnDefaultExchange())
                .with(RabbitKeyLineWarnConstants.DEFAULT_DEAD_ROUTING_KEY);
    }


    /**
     * 新增
     */
    @Bean
    public Queue lineWarnChildAddQueue() {
        return new Queue(RabbitKeyLineWarnConstants.ORDER_GOODS_ADD_QUEUE);
    }
    @Bean
    public Binding lineWarnChildAddQueueBinding() {
        return BindingBuilder.bind(lineWarnChildAddQueue()).to(lineWarnDefaultExchange())
                .with(RabbitKeyLineWarnConstants.ORDER_GOODS_ADD_ROUTING_KEY);
    }

    /**
     * 线路预警
     */
    @Bean
    public Queue lineWarnQueue() {
        return new Queue(RabbitKeyLineWarnConstants.LINE_WARN_QUEUE);
    }
    @Bean
    public Binding lineWarnQueueBinding() {
        return BindingBuilder.bind(lineWarnQueue()).to(lineWarnDefaultExchange())
                .with(RabbitKeyLineWarnConstants.LINE_WARN_ROUTING_KEY);
    }
    /**
     * 线路预警通知
     */
    @Bean
    public Queue lineWarnNoticeQueue() {
        return new Queue(RabbitKeyLineWarnConstants.LINE_WARN_NOTICE_QUEUE);
    }
    @Bean
    public Binding lineWarnNoticeQueueBinding() {
        return BindingBuilder.bind(lineWarnNoticeQueue()).to(lineWarnDefaultExchange())
                .with(RabbitKeyLineWarnConstants.LINE_WARN_NOTICE_ROUTING_KEY);
    }

    /**
     * 线路上报
     */
    @Bean
    public Queue lineWarnLineReportQueue() {
        return new Queue(RabbitKeyLineWarnConstants.LINE_WARN_LINE_REPORT_QUEUE);
    }
    @Bean
    public Binding lineWarnLineReportQueueBinding() {
        return BindingBuilder.bind(lineWarnLineReportQueue()).to(lineWarnDefaultExchange())
                .with(RabbitKeyLineWarnConstants.LINE_WARN_LINE_REPORT_ROUTING_KEY);
    }

    /**
     * 异常运单
     */
    @Bean
    public Queue lineWarnOrderChildWarnQueue() {
        return new Queue(RabbitKeyLineWarnConstants.LINE_WARN_ORDER_CHILD_WARN_QUEUE);
    }
    @Bean
    public Binding lineWarnOrderChildWarnQueueBinding() {
        return BindingBuilder.bind(lineWarnOrderChildWarnQueue()).to(lineWarnDefaultExchange())
                .with(RabbitKeyLineWarnConstants.LINE_WARN_ORDER_CHILD_WARN_ROUTING_KEY);
    }

}
