package com.clx.performance.param.pc.payment;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import lombok.experimental.Accessors;

import jakarta.validation.constraints.NotBlank;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Accessors(chain = true)
public class PayPlatformFeeParam {
	@Schema(description = "支付来源", example = "2234")
	Integer from;
	@Schema(description = "支付方密码", example = "2356")
	String pwd;

	@Schema(description = "金额", example = "2356")
	Integer figure;

	@Schema(description = "最新冻结金额金额", example = "2356")
	Integer figureNew;

	@NotBlank(message = "交易单号不能为空")
	@Schema(description = "交易单号", example = "2356")
	String tradeNo;
}
