package com.clx.performance.param.pc.breakcontract.carrier;

import com.msl.common.convertor.type.MoneyInConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @Author: aiqingguo
 * @Date: 2023-10-11 17:30:57
 * @Version: 1.0
 */
@Setter
@Getter
@ToString
@NoArgsConstructor
public class BreakContractDriverRecordAddParam {

    @Schema(description="违约方类型：1平台 3司机")
    @NotNull(message = "违约方类型不能为空")
    private Integer breakContractPartyType;

    @Schema(description="违约运单")
    @NotBlank(message = "违约运单不能为空")
    private String childNo;

    @Schema(description="违约金")
    @NotNull(message = "违约金不能为空")
    @Max(value = 999_999_999L, message = "金额不能超过999999999元")
    @Min(value = 0L, message = "金额不能小于0元")
    @MoneyInConvert
    private BigDecimal figure;

    @Schema(description="接单时间限制（小时）")
    private BigDecimal timeLimit;

    @Schema(description="备注")
    @NotBlank(message = "违约原因不能为空")
    private String remark;

}
