package com.clx.performance.param.feign.transport;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;

/**
 * 自然人货主同步
 */
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class OwnerPersonalSyncParam {

    @Schema(description = " 登陆手机号 ", required = true)
    @NotBlank(message = "货主登录手机号不可为空")
    private String mobile;
    @Schema(description = " 货主姓名 ", required = true)
    @NotBlank(message = "货主姓名不可为空")
    private String name;
    @Schema(description = " 身份证号 ", required = true)
    @NotBlank(message = "身份证号不可为空")
    private String cardNo;

    @Schema(description = " 省 ", required = true)
    private String province;
    @Schema(description = " 省code ", required = true)
    private Integer provinceCode;
    @Schema(description = " 市 ", required = true)
    private String city;
    @Schema(description = " 市code ", required = true)
    private Integer cityCode;
    @Schema(description = " 区县 ", required = true)
    private String county;
    @Schema(description = " 区县code ", required = true)
    private Integer countyCode;

//    @Schema(description = " 乡镇 ", required = false)
//    private String town;
//    @Schema(description = " 乡镇code ", required = false)
//    private Integer townCode;
//    @Schema(description = " 街道 ", required = false)
//    private String street;
//    @Schema(description = " 街道code ", required = false)
//    private Integer streetCode;

    @NotBlank(message = "详细地址不可为空")
    @Schema(description = " 详细地址 ", required = true)
    private String address;

    @NotBlank(message = "身份证正面图片不可为空")
    @Schema(description = " 身份证正面图片地址 ", required = true)
    private String legalFrontImg;
    @NotBlank(message = "身份证背面图片不可为空")
    @Schema(description = " 身份证背面图片地址 ", required = true)
    private String legalBackImg;
    @Schema(description = "手持身份证")
    private String personHandheldImg;

    @Schema(description = " 个人邮箱 ")
    private String businessEmail;

}
