package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum InputOutputEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Type {
        INPUT(1, "进场"),
        OUTPUT(2, "出场"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<Type> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(Type::getMsg).orElse(null);
        }
    }


}
