package com.clx.performance.listener;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.clx.performance.component.OrderChildLoanComponent;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.dao.loan.OwnerLoanAccountRunningWaterRecordDao;
import com.clx.performance.dao.settle.SettlementDriverDetailDao;
import com.clx.performance.dao.settle.SettlementOwnerDetailDao;
import com.clx.performance.dto.OwnerLoanMqDTO;
import com.clx.performance.enums.loan.OwnerLoanAccountRunningWaterRecordEnum;
import com.clx.performance.enums.loan.OwnerLoanRecordEnum;
import com.clx.performance.event.SettlementUpdateEvent;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.loan.OwnerLoanAccountRunningWaterRecord;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.service.settle.SettlementMqService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 处理货主借款冻结释放监听器
 */
@Slf4j
@Component
@AllArgsConstructor
public class OwnerLoanAccountThawListener {

    private final OrderChildLoanComponent orderChildLoanComponent;

    private final OwnerLoanAccountRunningWaterRecordDao ownerLoanAccountRunningWaterRecordDao;

    @RabbitListener(queues = RabbitKeyConstants.OWNER_LOAN_THAW_QUEUE)
    public void onMessage(String message) {
        log.info("货主借款冻结释放监听器{}", message);
        List<OwnerLoanAccountRunningWaterRecord> runningWaterRecordList = ownerLoanAccountRunningWaterRecordDao.getListByChildNoAndRunningWaterType(message);

        if (CollectionUtil.isEmpty(runningWaterRecordList)) {
            return;
        }
        Map<Integer, List<OwnerLoanAccountRunningWaterRecord>> listMap = runningWaterRecordList.stream().collect(Collectors.groupingBy(OwnerLoanAccountRunningWaterRecord::getRunningWaterType));

        List<OwnerLoanAccountRunningWaterRecord> thawRecord = listMap.get(OwnerLoanAccountRunningWaterRecordEnum.RunWaterType.APPROVE_THAW.getCode());
        if (CollectionUtil.isNotEmpty(thawRecord)) {
            log.info("3.1 有借款解冻记录,说明是是重复记录,直接返回");
            return;
        } else {
            runningWaterRecordList = listMap.get(OwnerLoanAccountRunningWaterRecordEnum.RunWaterType.APPROVE_FROZEN.getCode());
        }
        Long ownerUserNo = runningWaterRecordList.get(0).getOwnerUserNo();
        log.info("当前解冻货主：{},流水记录长度{},流水记录{}", ownerUserNo, runningWaterRecordList.size(), JSONUtil.parse(runningWaterRecordList));

        for (OwnerLoanAccountRunningWaterRecord record : runningWaterRecordList) {
            Long loanNo = record.getLoanNo();
            Integer loanType = record.getLoanType();
            String ownerUserName = record.getOwnerUserName();
            String childNo = record.getChildNo();
            BigDecimal balance = record.getAlterationBalance();
            //解冻借款
            orderChildLoanComponent.thawOwnerLoanAccount(loanNo, loanType, ownerUserNo, record.getMobile(), ownerUserName, childNo, balance);
        }
    }
}
