package com.clx.performance.vo.pc;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;


/**
 * @author yangqifa
 */
@Getter
@Setter
@ToString
public class OrderChildOperateLimitConfigVO {

    @Schema(description = "id")
    private Integer id;

    @Schema(description="配置名称")
    private String name;

    @Schema(description="可上传装车信息范围：默认2.0，最大9999.9")
    private BigDecimal allowUploadDistance;

    @Schema(description = "启用状态 0 禁用 1 启用")
    private Integer status;

    public Integer allowUploadDistanceMeter() {
        return allowUploadDistance.multiply(new BigDecimal(1000)).intValue();
    }
}
