package com.clx.performance.param.pc;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import jakarta.validation.constraints.NotBlank;

/**
 * @ClassName TruckTraceParam
 * @Description
 * @Author kavin
 * @Date 2023/11/13 9:47
 * @Version 1.0
 */

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class TruckTraceParam {

    @NotBlank(message = "车牌号不能为空")
    @Schema(description="车牌号")
    private String truckNo;
    @NotBlank(message = "开始时间不能为空")
    @Schema(description = "开始时间",example = "2023-11-11 12:00:00")
    private String beginTime;
    @NotBlank(message = "结束时间不能为空")
    @Schema(description = "结束时间",example = "2023-11-11 12:00:00")
    private String endTime;
}
