package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum OrderChildPoundAuditEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Status {
        AUDIT(0, "待审核"),
        APPROVED(1, "审核通过"),
        REJECT(2, "审核驳回"),

        ;

        private final Integer code;
        private final String msg;

        public static Optional<Status> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

}
