package com.clx.performance.model.export;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

@Getter
@Setter
@Accessors(chain = true)
@TableName("export_template_field")
public class ExportTemplateField implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("export_template_id")
    @Schema(description="导出模板id")
    private Integer exportTemplateId;

    @TableField("export_field_id")
    @Schema(description="导出字段id")
    private Integer exportFieldId;

    @TableField("sort")
    @Schema(description="排序字段")
    private Integer sort;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
        return this.id;
    }
}
