package com.clx.performance.controller.pc.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.enums.PlatformAccountConfigEnum;
import com.clx.performance.model.PlatformAccountConfig;
import com.clx.performance.param.pc.*;
import com.clx.performance.service.OwnerAccountService;
import com.clx.performance.service.OwnerCaseOutService;
import com.clx.performance.service.OwnerTopUpService;
import com.clx.performance.service.PlatformAccountConfigService;
import com.clx.performance.vo.pc.OwnerAccountRunningWaterRecordVO;
import com.clx.performance.vo.pc.OwnerAccountVO;
import com.clx.performance.vo.pc.OwnerCaseOutVO;
import com.clx.performance.vo.pc.OwnerTopUpVO;
import com.clx.performance.vo.pc.carrier.settle.CarrierPagePlatformAccountConfigVO;
import com.clx.user.param.pc.driver.truck.PageDriverTruckParam;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotBlank;
import java.util.List;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier")
@Validated
@Tag(name = "承运端-资金")
@AllArgsConstructor
public class CarrierAccountController {

    private final OwnerAccountService ownerAccountService;

    private final OwnerTopUpService ownerTopUpService;

    private final OwnerCaseOutService ownerCaseOutService;

    private final PlatformAccountConfigService platformAccountConfigService;


    @Operation(summary = "查看资金管理列表(保证金和预付运费)", description = "<br>By:胡宇帆")
    @PostMapping("/pageList")
    @UnitCovert(param = false)
    public Result<PageData<OwnerAccountVO>> pageList(@RequestBody PageOwnerAccountListParam param) {
        IPage<OwnerAccountVO> page = ownerAccountService.pageList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "预付运费账户列表")
    @PostMapping("/exportPrepaidFreightList")
    public void exportPrepaidFreightList(@RequestBody PageOwnerAccountListParam param, HttpServletResponse response) throws Exception {
        SXSSFWorkbook workbook = ownerAccountService.exportPrepaidFreightList(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
    }


    @Operation(summary = "保证金账户详情流水列表", description = "<br>By:胡宇帆")
    @PostMapping("/marginAccountPageList")
    @UnitCovert(param = false)
    public Result<PageData<OwnerAccountRunningWaterRecordVO>> marginAccountPageList(@RequestBody PagePlatformMarginAccountParam param) {
        IPage<OwnerAccountRunningWaterRecordVO> page = ownerAccountService.marginAccountPageList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "保证金账户详情流水下载")
    @PostMapping("/exportMarginAccountPageList")
    public void exportMarginAccountPageList(@RequestBody @Validated PagePlatformMarginAccountParam param, HttpServletResponse response) throws Exception {
        SXSSFWorkbook workbook = ownerAccountService.exportMarginAccountPageList(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
    }

    @Operation(summary = "预付金账户详情流水列表", description = "<br>By:胡宇帆")
    @PostMapping("/prepaidFreightAccountPageList")
    @UnitCovert(param = false)
    public Result<PageData<OwnerAccountRunningWaterRecordVO>> prepaidFreightAccountPageList(@RequestBody PagePlatformPrepaidFreightAccountParam param) {
        IPage<OwnerAccountRunningWaterRecordVO> page = ownerAccountService.prepaidFreightAccountPageList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "预付金账户详情流水下载")
    @PostMapping("/exportPrepaidFreightAccountPageList")
    public void exportPrepaidFreightAccountPageList(@RequestBody @Validated PagePlatformPrepaidFreightAccountParam param, HttpServletResponse response) throws Exception {
        SXSSFWorkbook workbook = ownerAccountService.exportPrepaidFreightAccountPageList(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
    }


    @Operation(summary = "充值审批", description = "<br>By:胡宇帆")
    @PostMapping("/accountTopUpApprove")
    public Result<Object> accountTopUpApprove(@RequestBody PlatformAccountTopUpParam param) {
        ownerAccountService.accountTopUpApprove(param);
        return Result.ok();
    }

    @Operation(summary = "提现审批", description = "<br>By:胡宇帆")
    @PostMapping("/accountCaseOutApprove")
    @UnitCovert()
    public Result<Object> accountCaseOutApprove(@RequestBody OwnerCaseOutApproveParam param) {
        ownerAccountService.accountCaseOutApprove(param);
        return Result.ok();
    }

    @Operation(summary = "充值审批列表", description = "<br>By:胡宇帆")
    @PostMapping("/ownerTopUpPageList")
    @UnitCovert(param = false)
    public Result<PageData<OwnerTopUpVO>> ownerTopUpPageList(@RequestBody PageOwnerTopUpListParam param) {
        IPage<OwnerTopUpVO> page = ownerTopUpService.ownerTopUpPageList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "提现审批列表", description = "<br>By:胡宇帆")
    @PostMapping("/ownerCaseOutPageList")
    @UnitCovert(param = false)
    public Result<PageData<OwnerCaseOutVO>> ownerCaseOutPageList(@RequestBody PageOwnerCaseOutListParam param) {
        IPage<OwnerCaseOutVO> page = ownerCaseOutService.ownerCaseOutPageList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "提现审批平台付款银行账号", description = "<br>By:jiangwenye")
    @GetMapping("/ownerCaseOutAccount")
    @UnitCovert(param = false)
    public Result<CarrierPagePlatformAccountConfigVO> ownerCaseOutAccount() {
        List<CarrierPagePlatformAccountConfigVO> configs =
                platformAccountConfigService.getPlatformAccountConfigByType(
                        PlatformAccountConfigEnum.BusinessType.WITHDRAWAL.getCode(),
                        PlatformAccountConfigEnum.OwnerType.COMPANY.getCode(),
                        null,null,null);
        if(CollectionUtils.isEmpty(configs)){
            throw new ServiceSystemException(PerformanceResultEnum.PLATFORM_ACCOUNT_CONFIG_WITHDRAWAL_IS_NULL);
        }
        if(configs.size() > 1){
            throw new ServiceSystemException(PerformanceResultEnum.PLATFORM_ACCOUNT_CONFIG_WITHDRAWAL_MANY);
        }
        return Result.ok(configs.get(0));
    }

}
