package com.clx.performance.controller.pc.loan.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.loan.carrier.*;
import com.clx.performance.param.pc.loan.owner.ExportPaymentApplicationFormParam;
import com.clx.performance.service.loan.OwnerLoanRecordService;
import com.clx.performance.vo.pc.loan.carrier.CarrierCashierInfoVO;
import com.clx.performance.vo.pc.loan.carrier.CarrierOwnerOrderPaymentDetailVO;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanRecordVO;
import com.clx.performance.vo.pc.loan.carrier.CarrierTransferPaymentDetailVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.annotations.Param;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/ownerLoanRecord")
@Validated
@Api(tags = "承运端-借款管理")
@AllArgsConstructor
public class CarrierOwnerLoanRecordController {

    private final OwnerLoanRecordService ownerLoanRecordService;


    @ApiOperation(value = "借款审批列表",notes = "<br>By:刘海泉")
    @PostMapping("/pageOwnerLoanRecord")
    @UnitCovert(param = false)
    public Result<PageData<OwnerLoanRecordVO>> pageOwnerLoanRecord(@RequestBody @Validated PageCarrierOwnerLoanRecordParam param) {
        IPage<OwnerLoanRecordVO> page  = ownerLoanRecordService.pageOwnerLoanRecord(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @ApiOperation(value = "借款审批(虚拟币直接增加,资金需要跳收银台提交申请)",notes = "<br>By:胡宇帆")
    @PostMapping("/ownerLoanRecordApprove")
    public Result<Object> ownerLoanRecordApprove(@RequestBody @Validated CarrierOwnerLoanRecordApproveParam param) {
        ownerLoanRecordService.ownerLoanRecordApprove(param);
        return Result.ok();
    }

    @ApiOperation(value = "借款提交申请(调用宁波银行)",notes = "<br>By:胡宇帆")
    @PostMapping("/ownerLoanRecordSubmitNbBank")
    public Result<Object> ownerLoanRecordSubmitNbBank(@RequestBody @Validated CarrierOwnerLoanRecordApproveParam param) {
        Integer id = ownerLoanRecordService.ownerLoanRecordSubmitNbBank(param);
        return Result.ok(id);
    }

    @ApiOperation(value = "借款重新支付(只更改借款状态)",notes = "<br>By:胡宇帆")
    @GetMapping("/ownerLoanRecordRetryPay")
    public Result<Object> ownerLoanRecordRetryPay(@RequestParam(value = "loanNo") @NotBlank String loanNo) {
        ownerLoanRecordService.ownerLoanRecordRetryPay(loanNo);
        return Result.ok();
    }

    @ApiOperation(value = "取消支付",notes = "<br>By:胡宇帆")
    @GetMapping("/ownerLoanRecordCancelPay")
    public Result<Object> ownerLoanRecordCancelPay(@RequestParam(value = "loanNo") @NotBlank String loanNo) {
        ownerLoanRecordService.ownerLoanRecordCancelPay(loanNo);
        return Result.ok();
    }

    @ApiOperation(value = "分页搜索货主借款列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageOwnerLoanRecordOfOwner")
    @UnitCovert(param = false)
    public Result<PageData<OwnerLoanRecordVO>> pageOwnerLoanRecordOfOwner(@RequestBody @Validated PageOwnerLoanRecordOfOwner param) {
        IPage<OwnerLoanRecordVO> page = ownerLoanRecordService.pageOwnerLoanRecordOfOwner(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "收银台信息",notes = "<br>By:刘海泉")
    @GetMapping("/getCashierInfo")
    @UnitCovert(param = false)
    public Result<CarrierCashierInfoVO> getCashierInfo(@RequestParam("id") @NotNull(message = "id不能为空") Integer id) {
        CarrierCashierInfoVO vo = ownerLoanRecordService.getCashierInfo(id);
        return Result.ok(vo);
    }


    @ApiOperation(value = "订单支付详情",notes = "<br>By:刘海泉")
    @GetMapping("/getOrderPaymentDetail")
    @UnitCovert(param = false)
    public Result<CarrierOwnerOrderPaymentDetailVO> getOrderPaymentDetail(@Param("id") @NotNull(message = "id不能为空") Integer id) {
        CarrierOwnerOrderPaymentDetailVO vo = ownerLoanRecordService.getOrderPaymentDetail(id);
        return Result.ok(vo);
    }

    @ApiOperation(value = "转账支付详情",notes = "<br>By:刘海泉")
    @GetMapping("/getTransferPaymentDetail")
    @UnitCovert(param = false)
    public Result<CarrierTransferPaymentDetailVO> getTransferPaymentDetail(@RequestParam("id") @NotNull(message = "id不能为空") Integer id) {
        CarrierTransferPaymentDetailVO vo = ownerLoanRecordService.getTransferPaymentDetail(id);
        return Result.ok(vo);
    }


    @ApiOperation(value = "生成付款申请单",notes = "<br>By:刘海泉")
    @PostMapping("/savePaymentApplicationForm")
    public Result<String> savePaymentApplicationForm(@RequestBody @Validated ExportPaymentApplicationFormParam param) {
        String url = ownerLoanRecordService.savePaymentApplicationForm(param);
        return Result.ok(url);
    }

//    @ApiOperation(value = "借款支付",notes = "<br>By:艾庆国")
//    @PostMapping("/updateOwnerLoanRecordPay")
//    public Result<Object> updateOwnerLoanRecordPay(@RequestBody @Validated CarrierOwnerLoanRecordPayParam param) {
//        ownerLoanRecordService.updateOwnerLoanRecordPay(param);
//        return Result.ok();
//    }

//    @ApiOperation(value = "借款重新支付",notes = "<br>By:艾庆国")
//    @PostMapping("/updateOwnerLoanRecordRepay")
//    public Result<Object> updateOwnerLoanRecordRepay(@RequestBody @Validated CarrierOwnerLoanRecordRepayParam param) {
//        ownerLoanRecordService.updateOwnerLoanRecordRepay(param);
//        return Result.ok();
//    }

/*    @ApiOperation(value = "借款支付取消",notes = "<br>By:艾庆国")
    @PostMapping("/updateOwnerLoanRecordPayCancel")
    public Result<Object> updateOwnerLoanRecordPayCancel(@RequestBody @Validated CarrierOwnerLoanRecordPayCancelParam param) {
        ownerLoanRecordService.updateOwnerLoanRecordPayCancel(param);
        return Result.ok();
    }*/

    @ApiOperation(value = "转账支付-借款短信", notes = "<br>By:姜文业")
    @GetMapping("/sendLoanSms")
    public Result<String> sendLoanSms(@RequestParam("mobile") @NotBlank(message = "通知的手机号码不能为空") String mobile,
                                         @Param("loanNo") @NotNull(message = "借款单号不能为空") Long loanNo) {
        String token = ownerLoanRecordService.sendLoanSms(mobile,loanNo);
        return Result.ok(token);
    }

    @ApiOperation(value = "订单支付短信", notes = "<br>By:姜文业")
    @GetMapping("/sendOrderPaySms")
    public Result<String> sendOrderPaySms(@RequestParam("mobile") @NotBlank(message = "通知的手机号码不能为空") String mobile,
                                          @Param("payee") @NotBlank(message = "收款方不能为空") String payee,
                                          @Param("payeeAccount") @NotBlank(message = "收款账户不能为空") String payeeAccount) {
        String token = ownerLoanRecordService.sendOrderPaySms(mobile,payee,payeeAccount);
        return Result.ok(token);
    }


}
