package com.clx.performance.service.impl;


import com.clx.performance.constant.RedisConstants;
import com.clx.performance.enums.PerformanceResultEnum;
import com.msl.common.exception.ServiceSystemException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.concurrent.ThreadLocalRandom;




@Slf4j
@Service
public class UniqueOrderNumService {

    @Autowired
    RedisTemplate<String, Object> jsonTemplate;

    /**
     * 获取指定日期唯一的订单号
     * @param  date 日期
     * @return 所指定日期的唯一订单号
     */
    public String getUniqueOrderNum(String date) {
        if(StringUtils.isBlank(date)){
            throw new ServiceSystemException(PerformanceResultEnum.DATA_NOT_FIND);
        }
        Integer orderNum = (Integer) jsonTemplate.opsForList().leftPop(RedisConstants.CARRIER_ORDER_NUM_POOL_KEY.replace("{date}", date));
        if(null == orderNum){
            throw new ServiceSystemException(PerformanceResultEnum.DATA_NOT_FIND);
        }
        return new StringBuilder().append(date).append(orderNum).append(String.format("%02d", ThreadLocalRandom.current().nextInt(99))).toString();
    }

}
