package com.clx.performance.service.impl;

import com.alibaba.fastjson.JSON;
import com.clx.performance.constant.RabbitKeyIntegralConstants;
import com.clx.performance.param.mq.*;
import com.clx.performance.service.IntegralMqService;
import com.clx.performance.common.MqDelay;
import com.clx.performance.common.MqWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Author: aiqingguo
 * @Description: 司机积分 mq
 * @Date: 2023-10-10 13:21:07
 * @Version: 1.0
 */

@Slf4j
@Service
public class IntegralMqServiceImpl implements IntegralMqService {

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Autowired
    private IntegralMqHandlerServiceImpl integralMqHandlerService;

    /**
     * 新增车辆 (user)
     */
    @Override
    public void truckAdd(String truckNo, String driverName, String driverMobile){

        IntegralTuckAddMqParam mq = new IntegralTuckAddMqParam();
        mq.setTruckNo(truckNo);
        mq.setDriverName(driverName);
        mq.setDriverMobile(driverMobile);
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(mq)).getBytes()).build();
        rabbitTemplate.send(RabbitKeyIntegralConstants.DEFAULT_EXCHANGE, RabbitKeyIntegralConstants.INTEGRAL_TRUCK_ADD_ROUTING_KEY, message);

    }

    /**
     * 新增货单 (performance)
     */
    @Override
    public void orderGoodsAdd(String orderGoodsNo,
                              Integer sendAddressId, String sendAddress,
                              Integer receiveAddressId, String receiveAddress){

        IntegralOrderAddMqParam mq = new IntegralOrderAddMqParam();
        mq.setOrderGoodsNo(orderGoodsNo);
        mq.setOrderType(1);
        mq.setSendAddressId(sendAddressId);
        mq.setSendAddress(sendAddress);
        mq.setReceiveAddressId(receiveAddressId);
        mq.setReceiveAddress(receiveAddress);

        MqDelay<MqWrapper<IntegralOrderAddMqParam>> delay = new MqDelay<>(RabbitKeyIntegralConstants.DEFAULT_EXCHANGE, RabbitKeyIntegralConstants.INTEGRAL_ORDER_GOODS_ADD_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyIntegralConstants.DEFAULT_EXCHANGE, RabbitKeyIntegralConstants.DEFAULT_DELAY_ROUTING_KEY, message);

    }

    /**
     * 新增积分记录 (performance)
     */
    @Override
    public void integralRecordAdd(Integer statisticsId, String truckNo, Integer type, Integer integral, String remark){

//        IntegralRecordAddMqParam mq = new IntegralRecordAddMqParam();
//        mq.setStatisticsId(statisticsId);
//        mq.setTruckNo(truckNo);
//        mq.setType(type);
//        mq.setIntegral(integral);
//        mq.setRemark(remark);
//        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(mq)).getBytes()).build();
//        rabbitTemplate.send(RabbitKeyIntegralConstants.DEFAULT_EXCHANGE, RabbitKeyIntegralConstants.INTEGRAL_RECORD_ADD_ROUTING_KEY, message);

        // 实时积分统计
        integralMqHandlerService.integralRealTimeStatistics(statisticsId);
    }

    /**
     * 下周车辆初始化 (job)
     */
    @Override
    public void nextWeekTruckInit(String statisticsDate){

        IntegralNextWeekTruckInitMqParam mq = new IntegralNextWeekTruckInitMqParam();
        mq.setStatisticsDate(statisticsDate);

        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(mq)).getBytes()).build();
        rabbitTemplate.send(RabbitKeyIntegralConstants.DEFAULT_EXCHANGE, RabbitKeyIntegralConstants.INTEGRAL_NEXT_WEEK_TRUCK_INIT_ROUTING_KEY, message);
    }

    /**
     * 车辆周统计 (结算上周积分) (job)
     */
    @Override
    public void weekTruckStatistics(String statisticsDate){

        IntegralWeekTruckStatisticsMqParam mq = new IntegralWeekTruckStatisticsMqParam();
        mq.setStatisticsDate(statisticsDate);

        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(mq)).getBytes()).build();
        rabbitTemplate.send(RabbitKeyIntegralConstants.DEFAULT_EXCHANGE, RabbitKeyIntegralConstants.INTEGRAL_WEEK_TRUCK_STATISTICS_ROUTING_KEY, message);
    }
    /**
     * 车辆周统计 (结算上周积分) (job)
     */
    @Override
    public void weekTruckStatistics(String statisticsDate, String truckNo){

        IntegralWeekTruckStatisticsMqParam mq = new IntegralWeekTruckStatisticsMqParam();
        mq.setStatisticsDate(statisticsDate);
        mq.setTruckNo(truckNo);

        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(mq)).getBytes()).build();
        rabbitTemplate.send(RabbitKeyIntegralConstants.DEFAULT_EXCHANGE, RabbitKeyIntegralConstants.INTEGRAL_WEEK_TRUCK_STATISTICS_ROUTING_KEY, message);
    }

    /**
     * 新车保护取消 (job)
     */
    @Override
    public void truckProtectionCancel(String statisticsDate, String truckNo){

        IntegralTruckProtectionCancelMqParam mq = new IntegralTruckProtectionCancelMqParam();
        mq.setStatisticsDate(statisticsDate);
        mq.setTruckNo(truckNo);

        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(mq)).getBytes()).build();
        rabbitTemplate.send(RabbitKeyIntegralConstants.DEFAULT_EXCHANGE, RabbitKeyIntegralConstants.INTEGRAL_TRUCK_PROTECTION_CANCEL_ROUTING_KEY, message);
    }

    /**
     * 运单结束 (performance)
     */
    @Override
    public void orderChildFinish(String childNo){

        IntegralOrderChildFinishMqParam mq = new IntegralOrderChildFinishMqParam();
        mq.setChildNo(childNo);

        MqDelay<MqWrapper<IntegralOrderChildFinishMqParam>> delay = new MqDelay<>(RabbitKeyIntegralConstants.DEFAULT_EXCHANGE, RabbitKeyIntegralConstants.INTEGRAL_ORDER_CHILD_FINISH_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyIntegralConstants.DEFAULT_EXCHANGE, RabbitKeyIntegralConstants.DEFAULT_DELAY_ROUTING_KEY, message);

    }

}
