package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.OwnerBindCardRecordDao;
import com.clx.performance.mapper.OwnerBindCardRecordMapper;
import com.clx.performance.model.OwnerBindCardRecord;
import com.clx.performance.param.pc.PageOwnerBindCardRecordListParam;
import com.clx.performance.vo.pc.OwnerAccountVO;
import com.clx.performance.vo.pc.OwnerBindCardRecordVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

@Repository
public class OwnerBindCardRecordDaoImpl extends BaseDaoImpl<OwnerBindCardRecordMapper, OwnerBindCardRecord, Integer> implements OwnerBindCardRecordDao {

    @Override
    public OwnerBindCardRecord getOwnerBindCardByUserNo(Long userNo) {
        return super.getOne(lQrWrapper()
                .eq(OwnerBindCardRecord::getOwnerUserNo, userNo)
                .last("limit 1")
        );
    }

    @Override
    public IPage<OwnerBindCardRecordVO> ownerBindCardPageList(PageOwnerBindCardRecordListParam param) {
        Page<OwnerBindCardRecordVO> page = Page.of(param.getPage(), param.getPageSize());

        return baseMapper.ownerBindCardPageList(page, param);
    }
}
