package com.clx.performance.service.impl.settle;

import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.settle.SettlementDriverDetailDao;
import com.clx.performance.dao.settle.SettlementOwnerDetailDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.service.settle.SettlementMqService;
import com.clx.performance.service.settle.SettlementService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Slf4j
@Service
public class SettlementServiceImpl implements SettlementService {


    @Autowired
    private OrderChildDao orderChildDao;
    @Autowired
    private SettlementOwnerDetailDao settlementOwnerDetailDao;
    @Autowired
    private SettlementDriverDetailDao settlementDriverDetailDao;
    @Autowired
    private SettlementMqService settlementMqService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateInvoiceType(String childNo, Integer invoiceType) {
        OrderChild orderChild = orderChildDao.getByChildNo(childNo).orElseThrow(PerformanceResultEnum.ORDER_CHILD_NO_FOUND);
        SettlementOwnerDetail settlementOwnerDetail = settlementOwnerDetailDao.getByChildNo(childNo).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        SettlementDriverDetail settlementDriverDetail = settlementDriverDetailDao.getByChildNo(childNo).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        if (settlementOwnerDetail.getInvoiceType() != null) {return;}

        settlementOwnerDetail.setInvoiceType(invoiceType);
        settlementDriverDetail.setInvoiceType(invoiceType);

        settlementOwnerDetailDao.updateInvoiceType(settlementOwnerDetail);
        settlementDriverDetailDao.updateInvoiceType(settlementDriverDetail);

        // 发送mq 通过开票标识
        settlementMqService.invoiceTypeSync(childNo, invoiceType);

    }
}
