package com.clx.performance.service.impl.settle;

import com.clx.performance.dao.settle.SettlementDriverDetailDao;
import com.clx.performance.dao.settle.SettlementOwnerDao;
import com.clx.performance.dao.settle.SettlementOwnerDetailDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.extranal.user.OwnerInfoService;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.model.settle.SettlementOwner;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.service.impl.UniqueOrderNumService;
import com.clx.performance.service.settle.SettlementMqHandlerService;
import com.clx.performance.vo.mq.SettlementDetailAddMqParam;
import com.clx.performance.vo.mq.SettlementDetailInvoiceTypeSyncMqParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;

@Slf4j
@Service
public class SettlementMqHandlerServiceImpl implements SettlementMqHandlerService {

    @Autowired
    private SettlementOwnerDetailDao settlementOwnerDetailDao;
    @Autowired
    private SettlementDriverDetailDao settlementDriverDetailDao;
    @Autowired
    private SettlementOwnerDao settlementOwnerDao;

    @Autowired
    private OwnerInfoService ownerInfoService;

    @Autowired
    private UniqueOrderNumService uniqueOrderNumService;



    @Override
    @Transactional(rollbackFor = Exception.class)
    public void settlementDetailInvoiceTypeSync(SettlementDetailInvoiceTypeSyncMqParam mq) {
        SettlementOwnerDetail settlementOwnerDetail = settlementOwnerDetailDao.getByChildNo(mq.getChildNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        SettlementDriverDetail settlementDriverDetail = settlementDriverDetailDao.getByChildNo(mq.getChildNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);


    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void settlementDetailAdd(SettlementDetailAddMqParam mq) {

    }

    /**
     * 月结初始化
     */
    private void settlementPeriodMonthInit(SettlementOwnerDetail settlementOwnerDetail, LocalDateTime settlementPeriodTime){

    }

    /**
     * 月结更新
     */
    private void settlementPeriodMonthUpdate(SettlementOwner settlementOwner, SettlementOwnerDetail settlementOwnerDetail){

    }

    /**
     * 拉运完成结 初始化
     */
    private void settlementPeriodImmediateInit(SettlementOwnerDetail settlementOwnerDetail){

    }

    /**
     * 拉运完成结 更新
     */
    private void settlementPeriodImmediateUpdate(SettlementOwner settlementOwner,SettlementOwnerDetail settlementOwnerDetail){

    }

    /**
     * 创建结算单号
     */
    private String settlementNoGenerate(){
        return uniqueOrderNumService.getUniqueOrderNum(com.msl.common.utils.LocalDateTimeUtils.convertLocalDateTimeToString(LocalDateTime.now(), com.msl.common.utils.LocalDateTimeUtils.DATE_DAY));
    }

}
