package com.clx.performance.service.impl.settle;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.settle.SettlementDriverDetailDao;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.param.pc.driver.PageCarrierSettlementDriverDetailParam;
import com.clx.performance.service.settle.SettlementDriverDetailService;
import com.clx.performance.struct.settle.SettlementDriverDetailStruct;
import com.clx.performance.vo.pc.carrier.settle.CarrierPageSettlementDriverDetailVO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * @author liruixin
 * Date 2023-10-12
 * Time 09:43
 */
@Service
@Slf4j
@AllArgsConstructor
public class SettlementDriverDetailServiceImpl  implements SettlementDriverDetailService {

    private final SettlementDriverDetailDao settlementDriverDetailDao;
    private final SettlementDriverDetailStruct settlementOwnerDetailStruct;

    @Override
    public Integer saveSettlementDetail(OrderChild orderChild) {

        SettlementDriverDetail settlementDriverDetail = new SettlementDriverDetail();
        settlementDriverDetail.setChildNo(orderChild.getChildNo());
        settlementDriverDetail.setOrderGoodsNo(orderChild.getOrderGoodsNo());
        settlementDriverDetail.setOrderNo(orderChild.getOrderNo());

        settlementDriverDetail.setDriverUserNo(orderChild.getTruckOwnUserNo());
        settlementDriverDetail.setDriverName(orderChild.getOwnerName());
        settlementDriverDetail.setTruckNo(orderChild.getTruckNo());

        settlementDriverDetail.setGoodsId(orderChild.getGoodsId());
        settlementDriverDetail.setGoodsName(orderChild.getGoodsName());

        // 运费
        settlementDriverDetail.setFreightPrice(orderChild.getFreightPrice());     //平台运费
        settlementDriverDetail.setWeight(weightCalc(orderChild.getLoadNet(), orderChild.getUnloadNet()));
        settlementDriverDetail.setFreight(freightCalc(settlementDriverDetail.getFreightPrice(), settlementDriverDetail.getWeight()));

        // 亏吨
        settlementDriverDetail.setLossPrice(orderChild.getLossPrice());
        settlementDriverDetail.setLossWeight(lossWeightCalc(orderChild.getLoadNet(), orderChild.getUnloadNet()));
        settlementDriverDetail.setLossFreight(lossFreightCalc(settlementDriverDetail.getLossPrice(), settlementDriverDetail.getLossWeight()));

        // 预付运费
        settlementDriverDetail.setPrepayFreight(BigDecimal.ZERO);


        // 结算金额
        settlementDriverDetail.setSettlementFreight(settlementFreightCalc(settlementDriverDetail.getFreight(), settlementDriverDetail.getLossFreight()));

        settlementDriverDetailDao.saveEntity(settlementDriverDetail);

        return settlementDriverDetail.getId();
    }

    private BigDecimal weightCalc(BigDecimal loadNet, BigDecimal unLoadNet){
        return unLoadNet.compareTo(loadNet) < 0? unLoadNet : loadNet;
    }

    /**
     *  运费计算
     */
    public BigDecimal freightCalc(BigDecimal freightPrice, BigDecimal weight){

        return freightPrice.multiply(weight).setScale(0, RoundingMode.HALF_UP);
    }

    /**
     * 亏吨计算
     */
    private BigDecimal lossWeightCalc(BigDecimal loadNet, BigDecimal unLoadNet){
        return unLoadNet.compareTo(loadNet) < 0? unLoadNet.subtract(loadNet) : BigDecimal.ZERO;
    }

    /**
     * 亏吨运费
     */
    private BigDecimal lossFreightCalc(BigDecimal freightPrice, BigDecimal weight){
        return freightPrice.multiply(weight).setScale(0, RoundingMode.HALF_UP);

    }

    /**
     * 开票金额
     */
    private BigDecimal invoiceFreightCalc(BigDecimal freight, BigDecimal lossFreight){
        return freight.subtract(lossFreight);
    }

    /**
     * 结算金额
     */
    private BigDecimal settlementFreightCalc(BigDecimal freight, BigDecimal lossFreight){
        return freight.subtract(lossFreight);
    }

    @Override
    public IPage<CarrierPageSettlementDriverDetailVO> pageSettlementDriverDetail(
            PageCarrierSettlementDriverDetailParam param) {
        IPage<SettlementDriverDetail> result = settlementDriverDetailDao.pageSettlementDriverDetail(param);
        List<CarrierPageSettlementDriverDetailVO> list = settlementOwnerDetailStruct.covertList(result.getRecords());
        return new Page<CarrierPageSettlementDriverDetailVO>().setRecords(list).setTotal(result.getTotal()).setPages(result.getPages());
    }
}
