package com.clx.performance.listener;

import com.alibaba.fastjson.JSON;
import com.clx.open.sdk.callback.OpenCallBackClient;
import com.clx.open.sdk.callback.message.OrderChildMessage;
import com.clx.performance.config.MslAppConfig;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.dto.dts.DataTransportDTO;
import com.clx.performance.enums.DtsOperationTypeEnum;
import com.clx.performance.enums.OrderChildEnum;
import com.msl.common.result.Result;
import com.msl.common.utils.DtsMapConvertUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

import java.util.Objects;


@Slf4j
@Component
@AllArgsConstructor
public class OrderChildDtsListener  {

    private final MslAppConfig mslAppConfig;


    @RabbitListener(queues = RabbitKeyConstants.CLX_PERFORMANCE_ORDER_CHILD_QUEUE)
    public void onMessage(Message message) {
        try {
            String msg = new String(message.getBody());
            log.info("DTS消息同步开始, database:clx_performance.order_child, msg:{}", msg);

            DataTransportDTO dataTransportDTO = JSON.parseObject(msg, DataTransportDTO.class);

            OrderChildMessage before = DtsMapConvertUtil.convert(dataTransportDTO.getBeforeMap(), new OrderChildMessage());
            OrderChildMessage after = DtsMapConvertUtil.convert(dataTransportDTO.getAfterMap(), new OrderChildMessage());

            if(Objects.equals(DtsOperationTypeEnum.INSERT.getCode(),dataTransportDTO.getOperationType().getCode())){
                //同步after数据
                log.info("新增:{}"+after);
//                OpenCallBackClient client = new OpenCallBackClient(mslAppConfig.getUrl(),mslAppConfig.getAppId(),mslAppConfig.getSecret());
//                Result result = client.encryptPost(JSON.toJSONString(after),after.topic());
//                log.info("响应结果:{}",JSON.toJSONString(result));

            }else if(Objects.equals(DtsOperationTypeEnum.UPDATE.getCode(),dataTransportDTO.getOperationType().getCode())){
                if(OrderChildEnum.SYNC_STATUS_lIST.contains(after.getStatus()) && !Objects.equals(before.getStatus(),after.getStatus())){
                    //同步after数据
                    log.info("修改:{}"+after);
//                    OpenCallBackClient client = new OpenCallBackClient(mslAppConfig.getUrl(),mslAppConfig.getAppId(),mslAppConfig.getSecret());
//                    Result result = client.encryptPost(JSON.toJSONString(after),after.topic());
//                    log.info("响应结果:{}",JSON.toJSONString(result));
                }
            }else if(Objects.equals(DtsOperationTypeEnum.DELETE.getCode(),dataTransportDTO.getOperationType().getCode())){
                //数据删除
                log.info("删除:{}"+before);

            }


        } catch (Exception e) {
            log.info("DTS消息同步失败, database:clx_performance.order_child, error:{}", e.getMessage());
        }
    }

}
