package com.clx.performance.dao.impl.settle;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.settle.SettlementOwnerDetailDao;
import com.clx.performance.mapper.settle.SettlementOwnerDetailMapper;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.param.pc.owner.PageCarrierSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PageOwnerSettlementOwnerDetailParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Objects;

/**
 * @Author: aiqinguo
 * @Description: 货主运单计费明细
 * @Date: 2023-10-11 18:04:09
 * @Version: 1.0
 */
@Repository
public class SettlementOwnerDetailDaoImpl extends BaseDaoImpl<SettlementOwnerDetailMapper, SettlementOwnerDetail, Integer> implements SettlementOwnerDetailDao {

    @Override
    public boolean updateInvoiceType(SettlementOwnerDetail item) {
        return false;
    }

    @Override
    public boolean updateSettlementNo(SettlementOwnerDetail item) {
        return false;
    }

    @Override
    public Optional<SettlementOwnerDetail> getByChildNo(String childNo) {
        return null;
    }

    @Override
    public IPage<SettlementOwnerDetail> pageSettlementOwnerDetail(
            PageCarrierSettlementOwnerDetailParam param) {
        LambdaQueryWrapper<SettlementOwnerDetail> query = new LambdaQueryWrapper<>();
        if(StringUtils.isNotBlank(param.getChildNo())){
            query.eq(SettlementOwnerDetail :: getChildNo,param.getChildNo());
        }
        if(StringUtils.isNotBlank(param.getOrderNo())){
            query.eq(SettlementOwnerDetail :: getOrderNo,param.getOrderNo());
        }
        if(Objects.nonNull(param.getOwnerUserNo())){
            query.eq(SettlementOwnerDetail :: getOwnerUserNo,param.getOwnerUserNo());
        }
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }

    @Override
    public IPage<SettlementOwnerDetail> pageOwnerSettlementOrderDetailList(PageOwnerSettlementOwnerDetailParam param) {
        LambdaQueryWrapper<SettlementOwnerDetail> query = new LambdaQueryWrapper<>();
        query.eq(SettlementOwnerDetail :: getSettlementNo,param.getSettlementNo());
        query.eq(StringUtils.isNotBlank(param.getChildNo()),SettlementOwnerDetail :: getChildNo,param.getChildNo());
        query.eq(StringUtils.isNotBlank(param.getOrderNo()),SettlementOwnerDetail :: getOrderNo,param.getOrderNo());
        query.eq(StringUtils.isNotBlank(param.getSettlementSubNo()),SettlementOwnerDetail :: getSettlementSubNo,param.getSettlementSubNo());
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }
}
