package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.OwnerAccountDao;
import com.clx.performance.mapper.OwnerAccountMapper;
import com.clx.performance.model.OwnerAccount;
import com.clx.performance.param.pc.PageOwnerAccountListParam;
import com.clx.performance.struct.OwnerAccountStruct;
import com.clx.performance.vo.pc.OwnerAccountVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import com.msl.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;

@Repository
public class OwnerAccountDaoImpl extends BaseDaoImpl<OwnerAccountMapper, OwnerAccount, Integer> implements OwnerAccountDao {


    @Override
    public IPage<OwnerAccountVO> pageList(PageOwnerAccountListParam param) {
        Page<OwnerAccountVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageList(page, param);

    }

    @Override
    public List<OwnerAccount> accountInfo(Long ownerUserNo) {
        return baseMapper.selectList(lQrWrapper().eq(OwnerAccount::getOwnerUserNo, ownerUserNo));

    }

    @Override
    public OwnerAccount getAccountByOwnerUserNoAndAccountType(Long ownerUserNo, Integer accountType) {
        return baseMapper.selectOne(lQrWrapper().eq(OwnerAccount::getAccountType, accountType).eq(OwnerAccount::getOwnerUserNo, ownerUserNo));
    }


    @Override
    public Integer updateOwnerAccountForConfirm(OwnerAccount account) {
        return baseMapper.updateOwnerAccountForConfirm(account);
    }

    @Override
    public Integer updateAccountCAS(OwnerAccount account, LocalDateTime now, boolean flag) {
        String nowStr = DateUtils.formatDateTime(now,"yyyy-MM-dd HH:mm:ss").get();
        if (flag) {
            return baseMapper.addAccount(account, nowStr);
        } else {
            return baseMapper.subAccount(account, nowStr);
        }
    }


}
