package com.clx.performance.controller.pc.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.owner.PageCarrierSettlementOwnerParam;
import com.clx.performance.service.settle.SettlementOwnerService;
import com.clx.performance.vo.pc.carrier.settle.*;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/settlementOwner")
@Validated
@Api(tags = "承运端-货主结算")
@AllArgsConstructor
public class CarrierSettlementOwnerController {

    private final SettlementOwnerService settlementOwnerService;


    @ApiOperation(value = "结算单详情",notes = "<br>By:李瑞新")
    @GetMapping("/getCarrierSettlementOwnerDetail")
    @UnitCovert(param = false)
    public Result<CarrierSettlementOwnerDetailVO> getCarrierSettlementOwnerDetail(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getCarrierSettlementOwnerDetail(id));
    }



    @ApiOperation(value = "承运端-结算单列表（货主）",notes = "<br>By:刘海泉")
    @PostMapping("/pageCarrierSettlementOwner")
    @UnitCovert(param = false)
    public Result<PageData<CarrierPageSettlementOwnerVO>> pageCarrierSettlementOwner(@RequestBody @Validated PageCarrierSettlementOwnerParam param) {
        IPage<CarrierPageSettlementOwnerVO> page = settlementOwnerService.pageCarrierSettlementOwner(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @ApiOperation(value = "货主结算单下载",notes = "<br>By:姜文业")
    @PostMapping("/exportCarrierSettlementOwnerPageList")
    public void exportCarrierSettlementOwnerPageList(@RequestBody @Validated PageCarrierSettlementOwnerParam param, HttpServletResponse response) throws Exception {
        SXSSFWorkbook workbook = settlementOwnerService.exportCarrierSettlementOwnerPageList(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
    }

    @ApiOperation(value = "货主结算单快递页面开票信息",notes = "<br>By:姜文业")
    @GetMapping("/getCarrierSettlementOwnerInvoiceCompany")
    @UnitCovert(param = false)
    public Result<CarrierSettlementOwnerCompanyVO> getCarrierSettlementOwnerInvoiceCompany(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getCarrierSettlementOwnerInvoiceCompany(id));
    }

    @ApiOperation(value = "货主结算单快递页面联系人信息",notes = "<br>By:姜文业")
    @GetMapping("/getCarrierSettlementOwnerCompanyContact")
    @UnitCovert(param = false)
    public Result<CarrierSettlementOwnerCompanyContactVO> getCarrierSettlementOwnerCompanyContact(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getCarrierSettlementOwnerCompanyContact(id));
    }

    @ApiOperation(value = "货主结算单付款页面收款人信息",notes = "<br>By:姜文业")
    @GetMapping("/getCarrierSettlementOwnerPayee")
    @UnitCovert(param = false)
    public Result<CarrierSettlementOwnerPayeeVO> getCarrierSettlementOwnerPayee(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getCarrierSettlementOwnerPayee(id));
    }

    @ApiOperation(value = "货主结算单快递页面快递信息",notes = "<br>By:姜文业")
    @GetMapping("/getCarrierSettlementOwnerExpress")
    @UnitCovert(param = false)
    public Result<CarrierSettlementOwnerExpressVO> getCarrierSettlementOwnerExpress(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getCarrierSettlementOwnerExpress(id));
    }

}
