package com.clx.performance.sqlProvider.settle;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.owner.PageOwnerSettlementOwnerDetailParam;
import com.clx.performance.vo.pc.owner.settle.PageOwnerSettlementOwnerDetailVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class SettlementOwnerDetailSqlProvider {


    public String pageOwnerSettlementOrderDetailList(@Param("page") Page<PageOwnerSettlementOwnerDetailVO> page, @Param("param") PageOwnerSettlementOwnerDetailParam param) {
        return new SQL(){{
            SELECT("owner_user_no,owner_name,settlement_no,settlement_sub_no," +
                    "child_no,order_no,goods_name,freight_price,weight," +
                    "freight,loss_price,loss_weight,loss_freight,prepay_freight," +
                    "settlement_freight,invoice_freight,invoice_type,final_payment_status,invoice_status," +
                    "date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime ");
            FROM("settlement_owner_detail ");
            WHERE("settlement_no = #{param.settlementNo}");
            if (StringUtils.isNotBlank(param.getSettlementSubNo())) {WHERE("settlement_sub_no = #{param.settlementSubNo}");}
            if (StringUtils.isNotBlank(param.getOrderNo())) {WHERE("order_no = #{param.orderNo}");}
            if (StringUtils.isNotBlank(param.getChildNo())) {WHERE("child_no = #{param.childNo}");}
            ORDER_BY("id desc");
        }}.toString();
    }


    public String getInvoiceType( @Param("orderNo") String orderNo) {
        return new SQL(){{
            SELECT("invoice_type");
            FROM("settlement_owner_detail");
            WHERE("order_no = '" + orderNo + "'");
            LIMIT(1);
        }}.toString();
    }


}
