package com.clx.performance.config;

import com.clx.performance.constant.RabbitKeyTraceConstants;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: aiqingguo
 * @Description: 轨迹 MQ
 * @Date: 2023-10-12 16:27:30
 * @Version: 1.0
 */
@Configuration
public class RabbitTraceConfig {

    @Bean
    public DirectExchange traceDefaultExchange() {
        return new DirectExchange(RabbitKeyTraceConstants.DEFAULT_EXCHANGE);
    }

    @Bean
    public Queue traceDefaultDelayQueue() {
        Map<String, Object> params = new HashMap<>(8);
        params.put("x-message-ttl", 15 * 60 * 1000);
        params.put("x-max-length", 5000000);
        params.put("x-dead-letter-exchange", RabbitKeyTraceConstants.DEFAULT_EXCHANGE);
        params.put("x-dead-letter-routing-key", RabbitKeyTraceConstants.DEFAULT_DEAD_ROUTING_KEY);
        return new Queue(RabbitKeyTraceConstants.DEFAULT_DELAY_QUEUE, true, false, false, params);
    }
    @Bean
    public Binding traceDefaultDelayQueueBinding() {
        return BindingBuilder.bind(traceDefaultDelayQueue()).to(traceDefaultExchange()).with(RabbitKeyTraceConstants.DEFAULT_DELAY_ROUTING_KEY);
    }

    @Bean
    public Queue traceDefaultDeadQueue() {
        return new Queue(RabbitKeyTraceConstants.DEFAULT_DEAD_QUEUE);
    }
    @Bean
    public Binding traceDefaultDeadQueueBinding() {
        return BindingBuilder.bind(traceDefaultDeadQueue()).to(traceDefaultExchange()).with(RabbitKeyTraceConstants.DEFAULT_DEAD_ROUTING_KEY);
    }

    /**
     * 统计更新
     */
    @Bean
    public Queue traceTruckTraceSyncQueue() {
        return new Queue(RabbitKeyTraceConstants.TRUCK_TRACE_SYNC_QUEUE);
    }
    @Bean
    public Binding traceTruckTraceSyncQueueBinding() {
        return BindingBuilder.bind(traceTruckTraceSyncQueue()).to(traceDefaultExchange()).with(RabbitKeyTraceConstants.TRUCK_TRACE_SYNC_ROUTING_KEY);
    }

}
