package com.clx.performance.param.feign.transport;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 法人货主同步
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
public class OwnerLegalSyncParam implements Serializable {

    @ApiModelProperty(value = " 法人姓名 ", required = true)
    @NotBlank(message = "货主登录手机号不可为空")
    private String name;
    @ApiModelProperty(value = " 货主手机号码 ", required = true)
    @NotBlank(message = "货主姓名不可为空")
    private String mobile;
    @ApiModelProperty(value = " 身份证号 ", required = true)
    @NotBlank(message = "身份证号不可为空")
    private String cardNo;

    @ApiModelProperty(value = " 企业名称 ", required = true)
    private String company;
    @ApiModelProperty(value = " 注册时间 ", required = true)
    private String registerTime;

    @ApiModelProperty(value = " 省 ", required = true)
    private String province;
    @ApiModelProperty(value = " 省code ", required = true)
    private Integer provinceCode;
    @ApiModelProperty(value = " 市 ", required = true)
    private String city;
    @ApiModelProperty(value = " 市code ", required = true)
    private Integer cityCode;
    @ApiModelProperty(value = " 区县 ", required = true)
    private String county;
    @ApiModelProperty(value = " 区县code ", required = true)
    private Integer countyCode;
    @ApiModelProperty(value = " 乡镇 ", required = true)
    private String town;
    @ApiModelProperty(value = " 乡镇code ", required = true)
    private Integer townCode;
    @ApiModelProperty(value = " 街道 ", required = true)
    private String street;
    @ApiModelProperty(value = " 街道code ", required = true)
    private Integer streetCode;
    @ApiModelProperty(value = " 详细地址 ", required = true)
    private String address;

    @ApiModelProperty(value = " 申请类型:1法人认证2代理人认证 ", required = true)
    private Integer applyType;
    @ApiModelProperty(value = " 法人姓名 ")
    private String legalName;
    @ApiModelProperty(value = " 法人手机号 ")
    private String legalMobile;
    @ApiModelProperty(value = " 法人身份证号 ")
    private String legalCardNo;
    @ApiModelProperty(value = " 法人身份证正面图片地址 ")
    private String legalFrontImg;
    @ApiModelProperty(value = " 法人身份证背面图片地址 ")
    private String legalBackImg;
    @ApiModelProperty(value = " 法人统一社会信用代码 ")
    private String legalGroupCode;
    @ApiModelProperty(value = " 法人营业执照图片地址 ")
    private String legalBusinessImg;

    @ApiModelProperty(value = " 代理人姓名 ")
    private String agentName;
    @ApiModelProperty(value = " 代理人手机号 ")
    private String agentMobile;
    @ApiModelProperty(value = " 代理人身份证号 ")
    private String agentCardNo;
    @ApiModelProperty(value = " 代理人身份证正面图片地址 ")
    private String agentFrontImg;
    @ApiModelProperty(value = " 代理人身份证背面图片地址 ")
    private String agentBackImg;
    @ApiModelProperty(value = " 代理人统一社会信用代码 ")
    private String agentGroupCode;
    @ApiModelProperty(value = " 代理人授权书图片地址 ")
    private String agentBusinessImg;

    @ApiModelProperty(value = " 企业联系人姓名 ", required = true)
    private String businessName;
    @ApiModelProperty(value = " 企业联系人手机号 ", required = true)
    private String businessMobile;
    @ApiModelProperty(value = " 企业类型 ", required = true)
    private Integer businessType;

    @ApiModelProperty(value = " 注册机构名称 ")
    private String registerOrgName;
    @ApiModelProperty(value = " 注册资本（单位：万元） ")
    private Double registerAmount;
    @ApiModelProperty(value = " 组织机构代码 ")
    private String orgGroupCode;
    @ApiModelProperty(value = " 企业邮箱 ")
    private String businessEmail;
    @ApiModelProperty(value = " 核准时间 ")
    private String checkTime;

}
