package com.clx.performance.controller.pc.vehiclewarn;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.vehiclewarn.*;
import com.clx.performance.service.vehiclewarn.VehicleWarnConfigService;
import com.clx.performance.vo.pc.vehiclewarn.VehicleWarnConfigVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.List;


@Slf4j
@RestController
@Validated
@Api(tags = "车辆预警-预警配置")
@RequestMapping(value="/pc/owner/vehicleWarnConfig")
public class VehicleWarnConfigController {

    @Autowired
    private VehicleWarnConfigService vehicleWarnConfigService;

    @ApiOperation(value = "新增配置", notes = "<br>By:艾庆国")
    @PostMapping("/saveConfig")
    @UnitCovert(result = false)
    public Result<Void> saveConfig(@RequestBody @Validated VehicleWarnConfigAddParam param) {

        vehicleWarnConfigService.saveConfig(param);

        return Result.ok();
    }

    @ApiOperation(value = "更新配置", notes = "<br>By:艾庆国")
    @PostMapping("/updateConfig")
    public Result<Void> updateConfig(@RequestBody @Validated VehicleWarnConfigUpdateParam param) {
        vehicleWarnConfigService.updateConfig(param);
        return Result.ok();
    }

    @ApiOperation(value = "更新配置状态", notes = "<br>By:艾庆国")
    @PostMapping("/updateStatus")
    public Result<Void> updateStatus(@RequestBody @Validated VehicleWarnConfigStatusUpdateParam param) {

        vehicleWarnConfigService.updateStatus(param);
        return Result.ok();
    }

    @ApiOperation(value = "删除配置", notes = "<br>By:艾庆国")
    @PostMapping("/deleteConfig")
    public Result<Void> deleteConfig(@RequestBody @Validated VehicleWarnConfigDeleteUpdateParam param) {
        vehicleWarnConfigService.deleteConfig(param);
        return Result.ok();
    }

    @ApiOperation(value = "获取配置信息",notes = "<br>By:艾庆国")
    @GetMapping("/getConfig")
    public Result<VehicleWarnConfigVO> getConfig(@NotNull(message = "id不能为空") @Validated Integer id) {
        return Result.ok(vehicleWarnConfigService.getConfig(id));
    }

    @ApiOperation(value = "分页搜索配置列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageConfig")
    public Result<PageData<VehicleWarnConfigVO>> pageConfig(@RequestBody @Validated PageVehicleWarnConfigParam param) {
        IPage<VehicleWarnConfigVO> page = vehicleWarnConfigService.pageConfig(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "预警类型下拉",notes = "<br>By:艾庆国")
    @GetMapping("/listWarnType")
    public Result<List<VehicleWarnConfigVO.WarnTypeItem>> listWarnType() {
        return Result.ok(vehicleWarnConfigService.listWarnType());
    }

}
