package com.clx.performance.controller.pc;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.enums.OrderChildEnum;
import com.clx.performance.param.pc.OrderChildCarrierCancelParam;
import com.clx.performance.param.pc.PageCarrierOrderChildParam;
import com.clx.performance.param.pc.PageMonitorOrderChildQCParam;
import com.clx.performance.service.ExternalInterfaceService;
import com.clx.performance.vo.MonthInComeAndOrderedVO;
import com.clx.performance.vo.pc.*;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@Slf4j
@RestController
@RequestMapping(value="/external/interface")
@Validated
@Api(tags = "对外提供该服务数据的接口")
@AllArgsConstructor
public class ExternalInterfaceController {

    private final ExternalInterfaceService externalInterfaceService;


    @ApiOperation(value = "获取车辆的月收入和月单量",notes = "<br>By:刘海泉")
    @GetMapping("/getTruckMonthIncomeAndOrderedNum")
    public Result<MonthInComeAndOrderedVO> getTruckMonthIncomeAndOrderedNum(@NotBlank(message = "车牌号不能为空") String truckNo) {
        return Result.ok(externalInterfaceService.getTruckMonthIncomeAndOrderedNum(truckNo));
    }

}
