package com.clx.performance.sqlProvider;

import cn.hutool.core.util.ObjectUtil;
import com.clx.performance.param.pc.PageOwnerCaseOutListParam;
import com.clx.performance.param.pc.PageOwnerTopUpListParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class OwnerCaseOutProvider {

    public String ownerCaseOutPageList(@Param("param") PageOwnerCaseOutListParam param) {
        String sql = new SQL() {{
            SELECT("a.id, a.owner_user_no," +
                    " a.case_out_no, a.case_out_balance, a.account_type, " +
                    " a.status,a.case_out_bank,a.case_out_bank_number,date_format(a.payment_time, '%Y-%m-%d %H:%i:%s') as payment_time,a.create_by,a.platform_payment_bank_number,a.platform_payment_bank,a.payment_by,a.payment_proof,date_format(a.create_time, '%Y-%m-%d %H:%i:%s') as create_time,a.modified_time");
            FROM("owner_case_out a");
            if (StringUtils.isNotBlank(param.getBeginTime()) && StringUtils.isNotBlank(param.getEndTime())) {
                WHERE("a.create_time >= #{param.beginTime} and a.create_time <= #{param.endTime}");
            }
            if (ObjectUtil.isNotNull(param.getAccountType())) {
                WHERE("a.account_type = #{param.accountType}");
            }
            if (ObjectUtil.isNotNull(param.getUserNo())) {
                WHERE("a.owner_user_no = #{param.userNo}");
            }
            ORDER_BY("a.create_time desc");
        }}.toString();
        return sql;
    }

}
