package com.clx.performance.vo.pc.integral;

import com.clx.performance.enums.integral.IntegralTruckRuleEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

/**
* @Author: aiqinguo
* @Description: 车辆积分规则
* @Date: 2023/11/06 14:12:53
* @Version: 1.0
*/

@ApiModel(description = "车辆积分规则")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class AppIntegralTruckRuleVO {

    @ApiModelProperty(value = "id", example = "")
    private Integer id;
    @ApiModelProperty(value = "层级名称", example = "")
    private String name;
    @ApiModelProperty(value = "积分起始范围", example = "")
    private Integer integralRatioBegin;
    @ApiModelProperty(value = "积分结束范围", example = "")
    private Integer integralRatioEnd;

    @ApiModelProperty(value = "积分结束范围", example = "")
    private String integralRatioMsg;
    public String getIntegralRatioMsg() {
        if (integralRatioBegin == null && integralRatioEnd !=null) {return "积分小于"+integralRatioEnd+"%";}
        if (integralRatioEnd == null && integralRatioBegin !=null) {return "积分大于"+integralRatioBegin+"%";}
        return "积分"+ integralRatioBegin+"%" + "—" + integralRatioEnd+"%";
    }

    @ApiModelProperty(value = "状态：1开启 2关闭", example = "")
    private Integer status;

    @ApiModelProperty(value = "状态：1开启 2关闭", example = "")
    private String statusMsg;
    public String getStatusMsg() {
        return IntegralTruckRuleEnum.Status.getByCode(status).get().getMsg();
    }

    @ApiModelProperty(value = "预期收益开始范围（分）", example = "")
    private BigDecimal incomeBegin;
    @ApiModelProperty(value = "预期收益结束范围（分）", example = "")
    private BigDecimal incomeEnd;

    @ApiModelProperty(value = "预期收益结束范围", example = "")
    private String incomeMsg;
    public String getIncomeMsg() {
        if (incomeBegin == null && incomeEnd !=null) {return "日收益小于等于"+incomeEnd.toString()+"元";}
        if (incomeEnd == null && incomeBegin !=null) {return "日收益大于等于"+incomeBegin.toString()+"元";}
        return "日收益"+ incomeBegin.toString() + "元—" + incomeEnd.toString()+"元";
    }

    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;
    @ApiModelProperty(value = "修改时间", example = "")
    private String modifiedTime;

}