package com.clx.performance.service.impl.breakcontract;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.order.vo.feign.FeignOrderInfoVO;
import com.clx.performance.dao.breakcontract.*;
import com.clx.performance.enums.*;
import com.clx.performance.extranal.user.OrderService;
import com.clx.performance.extranal.user.OwnerInfoService;
import com.clx.performance.model.breakcontract.*;
import com.clx.performance.param.pc.breakcontract.carrier.BreakContractOwnerRecordAddParam;
import com.clx.performance.param.pc.breakcontract.carrier.PageBreakContractOwnerRecordParam;
import com.clx.performance.param.pc.breakcontract.owner.PageOwnerBreakContractOwnerRecordParam;
import com.clx.performance.service.breakcontract.BreakContractOwnerRecordService;
import com.clx.performance.service.breakcontract.BreakContractSettlementLogService;
import com.clx.performance.service.impl.UniqueOrderNumService;
import com.clx.performance.struct.breakcontract.*;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractOwnerRecordVO;
import com.clx.performance.vo.pc.breakcontract.owner.PageOwnerBreakContractOwnerRecordVO;
import com.clx.user.vo.feign.OwnerInfoFeignVO;
import com.msl.common.utils.LocalDateTimeUtils;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Slf4j
@Service
@AllArgsConstructor
public class BreakContractOwnerRecordServiceImpl  implements BreakContractOwnerRecordService {


    private final BreakContractOwnerRecordDao breakContractOwnerRecordDao;

    private final OrderService orderService;

    private final UniqueOrderNumService uniqueOrderNumService;

    private final OwnerInfoService ownerInfoService;

    private final BreakContractOwnerRecordStruct breakContractOwnerRecordStruct;

    private final BreakContractSettlementOwnerDetailStruct breakContractSettlementOwnerDetailStruct;

    private final BreakContractSettlementOwnerStruct breakContractSettlementOwnerStruct;

    private final BreakContractSettlementOwnerDao breakContractSettlementOwnerDao;

    private final BreakContractSettlementOwnerDetailDao breakContractSettlementOwnerDetailDao;

    private final BreakContractSettlementLogService breakContractSettlementLogService;

    @Override
    public void saveRecord(BreakContractOwnerRecordAddParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        String breakNo = "WYD"+childNoGenerate();

        FeignOrderInfoVO orderInfo = orderService.getOrderInfo(param.getOrderNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        OwnerInfoFeignVO ownerInfo = ownerInfoService.getOwnerInfo(orderInfo.getOwnerUserNo());

        BreakContractOwnerRecord record = new BreakContractOwnerRecord();
        record.setBreakNo(breakNo);
        record.setTriggerType(BreakContractRecordEnum.TriggerType.MANUAL.getCode());
        if (Objects.equals(param.getBreakContractPartyType(), BreakContractRecordEnum.BreakContractPartyType.OWNER.getCode())) {
            record.setBreakContractPartyType(BreakContractRecordEnum.BreakContractPartyType.OWNER.getCode());
        }
        else {
            record.setBreakContractPartyType(BreakContractRecordEnum.BreakContractPartyType.PLATFORM.getCode());
        }

        record.setOrderNo(param.getOrderNo());
        record.setFigure(param.getFigure());
        record.setRemark(param.getRemark());

        record.setOwnerUserNo(ownerInfo.getUserNo());
        record.setOwnerName(ownerInfo.getName());

        record.setCreateBy(userNo);
        record.setCreateName(loginUserInfo.getUserName());


        //货主违约计费明细
        BreakContractSettlementOwnerDetail breakOwnerDetail = breakContractSettlementOwnerDetailStruct.convert(record);
        String settlementNo = "WYJSD"+childNoGenerate();
        breakOwnerDetail.setSettlementNo(settlementNo);

        //货主违约结算单
        BreakContractSettlementOwner breakOwner = breakContractSettlementOwnerStruct.convert(breakOwnerDetail);
        breakOwner.setStatus(BreakContractSettlementOwnerEnum.Status.TO_BE_ACCOUNT.getCode());

        record.setSettlementNo(settlementNo);
        //保存违约记录
        breakContractOwnerRecordDao.saveEntity(record);
        //保存违约计费
        breakContractSettlementOwnerDao.saveEntity(breakOwner);
        //保存违约结算单
        breakContractSettlementOwnerDetailDao.saveEntity(breakOwnerDetail);
        //保存结算单日志----创建结算单
        breakContractSettlementLogService.saveBreakSettlementLog(settlementNo,
                BreakContractSettlementLogEnum.Type.CREATE_SETTLEMENT.getCode(),BreakContractSettlementLogEnum.Type.CREATE_SETTLEMENT.getMsg(),
                OrderChildLogEnum.CreateType.PLATFORM.getCode(),userNo,loginUserInfo.getUserName());
    }

    @Override
    public IPage<BreakContractOwnerRecordVO> pageRecord(PageBreakContractOwnerRecordParam param) {
        return breakContractOwnerRecordDao.pageByParam(param);

    }

    /**
     * 创建违约号
     */
    private String childNoGenerate() {
        return uniqueOrderNumService.getUniqueOrderNum(
                LocalDateTimeUtils.convertLocalDateTimeToString(LocalDateTime.now(), LocalDateTimeUtils.DATE_DAY));
    }

    @Override
    public IPage<PageOwnerBreakContractOwnerRecordVO> pageOwnerRecord(PageOwnerBreakContractOwnerRecordParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        param.setOwnerUserNo(loginUserInfo.getUserNo());
        IPage<BreakContractOwnerRecord> ownerRecord = breakContractOwnerRecordDao.pageOwnerBreakContractOwnerRecordList(param);
        List<PageOwnerBreakContractOwnerRecordVO> ownerRecordVO = breakContractOwnerRecordStruct.covertToOwnerList(ownerRecord.getRecords());
        return new Page<PageOwnerBreakContractOwnerRecordVO>().setRecords(ownerRecordVO).setTotal(ownerRecord.getTotal()).setPages(ownerRecord.getPages());

    }

    @Override
    public void autoSaveRecord(BreakContractOwnerRecordAddParam param) {

        String breakNo = "WYD"+childNoGenerate();

        FeignOrderInfoVO orderInfo = orderService.getOrderInfo(param.getOrderNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        OwnerInfoFeignVO ownerInfo = ownerInfoService.getOwnerInfo(orderInfo.getOwnerUserNo());

        BreakContractOwnerRecord record = new BreakContractOwnerRecord();
        record.setBreakNo(breakNo);
        record.setTriggerType(BreakContractRecordEnum.TriggerType.SYSTEM.getCode());
        record.setBreakContractPartyType(BreakContractRecordEnum.BreakContractPartyType.OWNER.getCode());

        record.setOrderNo(param.getOrderNo());
        record.setFigure(param.getFigure());
        record.setRemark(param.getRemark());

        record.setOwnerUserNo(ownerInfo.getUserNo());
        record.setOwnerName(ownerInfo.getName());

        record.setCreateBy(0L);
        record.setCreateName("系统");


        //货主违约计费明细
        BreakContractSettlementOwnerDetail breakOwnerDetail = breakContractSettlementOwnerDetailStruct.convert(record);
        String settlementNo = "WYJSD"+childNoGenerate();
        breakOwnerDetail.setSettlementNo(settlementNo);

        //货主违约结算单
        BreakContractSettlementOwner breakOwner = breakContractSettlementOwnerStruct.convert(breakOwnerDetail);
        breakOwner.setStatus(BreakContractSettlementOwnerEnum.Status.TO_BE_ACCOUNT.getCode());

        record.setSettlementNo(settlementNo);
        //保存违约记录
        breakContractOwnerRecordDao.saveEntity(record);
        //保存违约计费
        breakContractSettlementOwnerDao.saveEntity(breakOwner);
        //保存违约结算单
        breakContractSettlementOwnerDetailDao.saveEntity(breakOwnerDetail);
        //保存结算单日志----创建结算单
        breakContractSettlementLogService.saveBreakSettlementLog(settlementNo,
                BreakContractSettlementLogEnum.Type.CREATE_SETTLEMENT.getCode(),BreakContractSettlementLogEnum.Type.CREATE_SETTLEMENT.getMsg(),
                OrderChildLogEnum.CreateType.PLATFORM.getCode(),record.getCreateBy(),record.getCreateName());
    }
}
