package com.clx.performance.enums.collect;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * 采集拉运意向删除状态
 * @author 诚联信
 */
public enum CollectDriverTransportIntentionEnum {

    ;

    @Getter
    @AllArgsConstructor
    public enum DeleteStatusType {
        // 0-否;1-是
        DELETE_STATUS_NO(0,"否"),
        DELETE_STATUS_YES(1,"是");

        private Integer code;
        private String message;

        public static Optional<DeleteStatusType> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    @Getter
    @AllArgsConstructor
    public enum StatusType {
        // 1启用 2禁用
        STATUS_ENABLE(1,"启用"),
        STATUS_DISABLE(2,"禁用");

        private Integer code;
        private String message;

        public static Optional<StatusType> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    @Getter
    @AllArgsConstructor
    public enum DefaultSortType {
        // 默认排序0
        DEFAULT_SORT(0,"默认排序");

        private Integer code;
        private String message;

        public static Optional<DefaultSortType> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }



}
