package com.clx.performance.sqlProvider;

import com.clx.order.enums.DeleteStatusEnum;
import com.clx.performance.model.TruckPosition;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Objects;

/**
 * 车辆位置;
 *
 * @author : jiangwenye
 * @date : 2024-05-29
 */
public class TruckPositionProvider {

    public String replaceTruckPosition(List<TruckPosition> truckPositionList) {
        StringBuffer sqlList = new StringBuffer();

        sqlList.append(" REPLACE INTO truck_position " +
                "(truck_no,child_no,child_status,child_province,truck_province," +
                "longitude,latitude,delete_status) " +
                " VALUES ");
        for (int i = 0; i < truckPositionList.size(); i++) {
            TruckPosition tp = truckPositionList.get(i);
            sqlList.append(" ('")
                    .append(tp.getTruckNo()).append("','")
                    .append(StringUtils.isEmpty(tp.getChildNo())?"":tp.getChildNo()).append("',")
                    .append(Objects.isNull(tp.getChildStatus())?0:tp.getChildStatus()).append(",'")
                    .append(StringUtils.isEmpty(tp.getChildProvince())?"":tp.getChildProvince()).append("','")
                    .append(StringUtils.isEmpty(tp.getTruckProvince())?"":tp.getTruckProvince()).append("',")
                    .append(Objects.isNull(tp.getLongitude())?0:tp.getLongitude()).append(",")
                    .append(Objects.isNull(tp.getLatitude())?0:tp.getLatitude()).append(",")
                    .append(DeleteStatusEnum.NO.getCode())
                    .append(")");
            if (i < truckPositionList.size() - 1) {
                sqlList.append(",");
            }
        }
        return sqlList.toString();
    }

}
