package com.clx.performance.model.settle;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class SettlementOrderChildRisk implements HasKey<Integer> {
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                            // ID

    private String childNo;                        // 子订单编号
    private String truckNo;                        // 车牌号
    private String driverName;                     // 司机姓名
    private String driverMobile;                   // 司机手机号
    private String goodsName;                      // 货物名称
    private Integer invoiceType;                   // 开票标识：1网运单 2普通单
    private LocalDateTime poundAuditTime;          // 磅单审核通过时间
    private Integer riskType;                      // 风控标识：1同步失败 2结算打回
    private String riskRemark;                     // 风控失败原因
    private Integer processMethod;                 // 处理方式：1重新同步 2转普通单
    private String processBy;                      // 处理人
    private LocalDateTime processTime;             // 处理时间
    private Integer status;                        // 处理状态：1待处理 2已处理
    private LocalDateTime createTime;              // 创建时间
    private LocalDateTime modifiedTime;            // 修改时间

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
        return this.id;
    }
}