package com.clx.performance.model.collect;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * @author kavin
 * Date 2024-10-18
 * Time 18:03
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("driver_transport_intention_info")
public class DriverTransportIntentionInfo implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("create_user_no")
    @Schema(description="操作人编码")
    private Long createUserNo;

    @TableField("create_user_name")
    @Schema(description="操作人")
    private String createUserName;

    @TableField("collect_transport_intention_id")
    @Schema(description="选项排序编号")
    private Integer collectTransportIntentionId;

    @TableField("collect_transport_intention_name")
    @Schema(description="问题名称")
    private String collectTransportIntentionName;

    @TableField("collect_transport_intention_record_id")
    @Schema(description="选项名称")
    private Integer collectTransportIntentionRecordId;

    @TableField("collect_transport_intention_record_name")
    @Schema(description="选项名称")
    private String collectTransportIntentionRecordName;

    @TableField("create_time")
    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
