package com.clx.performance.model.collect;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Optional;

/**
* @Author: aiqinguo
* @Description: 线路排队耗时
* @Date: 2023/10/16 13:06:27
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class CollectTruckWait implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private Long userNo;                            //用户编号
    private String name;                            //用户姓名
    private String mobile;                          //手机号码
    private String truckNo;                         //车牌号
    private String childNo;                         //运单编号
    private Integer addressId;                      //地址id
    private String address;                         //详细地址
    private Integer reportType;                     //上报类型：1 装车类型 2卸车类型
    private Integer waitType;                       //上报类型：1 无需排队 2 场内需要排队 3 厂外需要排队
    private BigDecimal stationInTime;               //预计站内等待时长
    private String stationInImage;                  //预计站内等待时长图片
    private BigDecimal stationOutTime;              //预计站外等待时长
    private String stationOutImage;                 //预计站外等待时长图片
    private LocalDateTime reportTime;               //上报时间
    private Integer auditStatus;                    //审核状态：0待审核 1已审核
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

    @Getter
    @AllArgsConstructor
    public enum ReportType {
        LOAD(1, "装车类型"),
        UNLOAD(2, "卸车类型");
        private final Integer code;
        private final String msg;

        public static Optional<ReportType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    @Getter
    @AllArgsConstructor
    public enum waitType {
        LOAD(1, "装车类型"),
        UNLOAD(2, "卸车类型");
        private final Integer code;
        private final String msg;

        public static Optional<waitType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    @Getter
    @AllArgsConstructor
    public enum AuditStatus {
        UNAUDIT(0, "待审核"),
        AUDIT(1, "已审核");
        private final Integer code;
        private final String msg;

        public static Optional<AuditStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

}