package com.clx.performance.model.collect;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-10-17
 * Time 16:26
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("collect_driver_transport_intention_record")
public class CollectDriverTransportIntentionRecord implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("collect_driver_transport_intention_id")
    @Schema(description="收集司机拉运意向id")
    private Integer collectDriverTransportIntentionId;

    @TableField("collect_record_sort_no")
    @Schema(description="选项排序编号")
    private Integer collectRecordSort;

    @TableField("collect_record_name")
    @Schema(description="选项名称")
    private String collectRecordName;

    @TableField("create_user_no")
    @Schema(description="操作人编码")
    private Long createUserNo;

    @TableField("create_user_name")
    @Schema(description="操作人")
    private String createUserName;

    @TableField("delete_status")
    @Schema(description="删除状态: 0-否;1-是")
    private Integer deleteStatus;

    @TableField("create_time")
    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
