package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * @author jiangwujie
 * Date 2024-08-08
 * Time 11:20
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("order_child_operate_record")
public class OrderChildOperateRecord implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("child_no")
    @Schema(description="运单编号")
    private String childNo;

    @TableField("type")
    @Schema(description="操作类型 1 取消运单 2 解除装车限制")
    private Integer type;

    @TableField("truck_no")
    @Schema(description="主车牌照")
    private String truckNo;

    @TableField("driver_name")
    @Schema(description="司机名称")
    private String driverName;

    @TableField("driver_mobile")
    @Schema(description="司机手机号")
    private String driverMobile;

    @TableField("send_address")
    @Schema(description="货源地")
    private String sendAddress;

    @TableField("receive_address")
    @Schema(description="目的地")
    private String receiveAddress;

    @TableField("good_type_name")
    @Schema(description="货物类型名称")
    private String goodTypeName;

    @TableField("remark")
    @Schema(description="备注")
    private String remark;

    @TableField("operate_time")
    @Schema(description="操作时间")
    private LocalDateTime operateTime;

    @TableField("operator")
    @Schema(description="操作人")
    private String operator;

    @TableField("created_time")
    @Schema(description="创建时间")
    private LocalDateTime createdTime;

    @TableField("modified_time")
    @Schema(description="更新时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
        return this.id;
    }
}
